@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementSqliMatchStatementFieldToMatchHeaderMatchPatternArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property all An empty configuration block that is used for inspecting all headers.
 * @property excludedHeaders An array of strings that will be used for inspecting headers that do not have a key that matches one of the provided values.
 * @property includedHeaders An array of strings that will be used for inspecting headers that have a key that matches one of the provided values.
 */
public data class WebAclRuleStatementSqliMatchStatementFieldToMatchHeaderMatchPatternArgs(
    public val all:
    Output<WebAclRuleStatementSqliMatchStatementFieldToMatchHeaderMatchPatternAllArgs>? = null,
    public val excludedHeaders: Output<List<String>>? = null,
    public val includedHeaders: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementSqliMatchStatementFieldToMatchHeaderMatchPatternArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementSqliMatchStatementFieldToMatchHeaderMatchPatternArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementSqliMatchStatementFieldToMatchHeaderMatchPatternArgs.builder()
            .all(all?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .excludedHeaders(excludedHeaders?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .includedHeaders(includedHeaders?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [WebAclRuleStatementSqliMatchStatementFieldToMatchHeaderMatchPatternArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementSqliMatchStatementFieldToMatchHeaderMatchPatternArgsBuilder internal
constructor() {
    private var all:
        Output<WebAclRuleStatementSqliMatchStatementFieldToMatchHeaderMatchPatternAllArgs>? = null

    private var excludedHeaders: Output<List<String>>? = null

    private var includedHeaders: Output<List<String>>? = null

    /**
     * @param value An empty configuration block that is used for inspecting all headers.
     */
    @JvmName("aupuisqgekbkgtgu")
    public suspend
    fun all(`value`: Output<WebAclRuleStatementSqliMatchStatementFieldToMatchHeaderMatchPatternAllArgs>) {
        this.all = value
    }

    /**
     * @param value An array of strings that will be used for inspecting headers that do not have a key that matches one of the provided values.
     */
    @JvmName("vtajnbycoopatjiy")
    public suspend fun excludedHeaders(`value`: Output<List<String>>) {
        this.excludedHeaders = value
    }

    @JvmName("hvewigtqvyjwjdrm")
    public suspend fun excludedHeaders(vararg values: Output<String>) {
        this.excludedHeaders = Output.all(values.asList())
    }

    /**
     * @param values An array of strings that will be used for inspecting headers that do not have a key that matches one of the provided values.
     */
    @JvmName("sqrcbmqbpdrtglbm")
    public suspend fun excludedHeaders(values: List<Output<String>>) {
        this.excludedHeaders = Output.all(values)
    }

    /**
     * @param value An array of strings that will be used for inspecting headers that have a key that matches one of the provided values.
     */
    @JvmName("tlsciqxlpfpvsmhx")
    public suspend fun includedHeaders(`value`: Output<List<String>>) {
        this.includedHeaders = value
    }

    @JvmName("ainauwowtqfsqrkb")
    public suspend fun includedHeaders(vararg values: Output<String>) {
        this.includedHeaders = Output.all(values.asList())
    }

    /**
     * @param values An array of strings that will be used for inspecting headers that have a key that matches one of the provided values.
     */
    @JvmName("ythabcrgjfqpmvjk")
    public suspend fun includedHeaders(values: List<Output<String>>) {
        this.includedHeaders = Output.all(values)
    }

    /**
     * @param value An empty configuration block that is used for inspecting all headers.
     */
    @JvmName("igchxbvsncsbwojc")
    public suspend
    fun all(`value`: WebAclRuleStatementSqliMatchStatementFieldToMatchHeaderMatchPatternAllArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.all = mapped
    }

    /**
     * @param argument An empty configuration block that is used for inspecting all headers.
     */
    @JvmName("nvwthvojrnkjlhps")
    public suspend
    fun all(argument: suspend WebAclRuleStatementSqliMatchStatementFieldToMatchHeaderMatchPatternAllArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementSqliMatchStatementFieldToMatchHeaderMatchPatternAllArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.all = mapped
    }

    /**
     * @param value An array of strings that will be used for inspecting headers that do not have a key that matches one of the provided values.
     */
    @JvmName("kesvjqqxsuqbqrfa")
    public suspend fun excludedHeaders(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludedHeaders = mapped
    }

    /**
     * @param values An array of strings that will be used for inspecting headers that do not have a key that matches one of the provided values.
     */
    @JvmName("urltgnkcfoqrgjcl")
    public suspend fun excludedHeaders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludedHeaders = mapped
    }

    /**
     * @param value An array of strings that will be used for inspecting headers that have a key that matches one of the provided values.
     */
    @JvmName("immavpylkqewuqyo")
    public suspend fun includedHeaders(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includedHeaders = mapped
    }

    /**
     * @param values An array of strings that will be used for inspecting headers that have a key that matches one of the provided values.
     */
    @JvmName("flokkoyyvfaxjlty")
    public suspend fun includedHeaders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.includedHeaders = mapped
    }

    internal fun build(): WebAclRuleStatementSqliMatchStatementFieldToMatchHeaderMatchPatternArgs =
        WebAclRuleStatementSqliMatchStatementFieldToMatchHeaderMatchPatternArgs(
            all = all,
            excludedHeaders = excludedHeaders,
            includedHeaders = includedHeaders,
        )
}
