@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementXssMatchStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property fieldToMatch Part of a web request that you want AWS WAF to inspect. See `field_to_match` below for details.
 * @property textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
 */
public data class WebAclRuleStatementXssMatchStatementArgs(
    public val fieldToMatch: Output<WebAclRuleStatementXssMatchStatementFieldToMatchArgs>? = null,
    public val textTransformations:
    Output<List<WebAclRuleStatementXssMatchStatementTextTransformationArgs>>,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementXssMatchStatementArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleStatementXssMatchStatementArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementXssMatchStatementArgs.builder()
            .fieldToMatch(fieldToMatch?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .textTransformations(
                textTransformations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleStatementXssMatchStatementArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementXssMatchStatementArgsBuilder internal constructor() {
    private var fieldToMatch: Output<WebAclRuleStatementXssMatchStatementFieldToMatchArgs>? = null

    private var textTransformations:
        Output<List<WebAclRuleStatementXssMatchStatementTextTransformationArgs>>? = null

    /**
     * @param value Part of a web request that you want AWS WAF to inspect. See `field_to_match` below for details.
     */
    @JvmName("usocypvtvckrbphp")
    public suspend
    fun fieldToMatch(`value`: Output<WebAclRuleStatementXssMatchStatementFieldToMatchArgs>) {
        this.fieldToMatch = value
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("lyrxhfjccecboroc")
    public suspend
    fun textTransformations(`value`: Output<List<WebAclRuleStatementXssMatchStatementTextTransformationArgs>>) {
        this.textTransformations = value
    }

    @JvmName("nuxxoxbkbgjpllms")
    public suspend fun textTransformations(
        vararg
        values: Output<WebAclRuleStatementXssMatchStatementTextTransformationArgs>,
    ) {
        this.textTransformations = Output.all(values.asList())
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("mcnyhunxkvrgumob")
    public suspend
    fun textTransformations(values: List<Output<WebAclRuleStatementXssMatchStatementTextTransformationArgs>>) {
        this.textTransformations = Output.all(values)
    }

    /**
     * @param value Part of a web request that you want AWS WAF to inspect. See `field_to_match` below for details.
     */
    @JvmName("sportvkjcapxfvqn")
    public suspend fun fieldToMatch(`value`: WebAclRuleStatementXssMatchStatementFieldToMatchArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fieldToMatch = mapped
    }

    /**
     * @param argument Part of a web request that you want AWS WAF to inspect. See `field_to_match` below for details.
     */
    @JvmName("xoswthglivgfwmfo")
    public suspend
    fun fieldToMatch(argument: suspend WebAclRuleStatementXssMatchStatementFieldToMatchArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleStatementXssMatchStatementFieldToMatchArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.fieldToMatch = mapped
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("mxmqnvjkeylgkcqv")
    public suspend
    fun textTransformations(`value`: List<WebAclRuleStatementXssMatchStatementTextTransformationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("rjhdulnghqgmouiy")
    public suspend
    fun textTransformations(argument: List<suspend WebAclRuleStatementXssMatchStatementTextTransformationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementXssMatchStatementTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("mjjfcebpjscttidf")
    public suspend fun textTransformations(
        vararg
        argument: suspend WebAclRuleStatementXssMatchStatementTextTransformationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementXssMatchStatementTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("bvjpcnpcynbbveyn")
    public suspend
    fun textTransformations(argument: suspend WebAclRuleStatementXssMatchStatementTextTransformationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclRuleStatementXssMatchStatementTextTransformationArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("iclweckhfufqulgq")
    public suspend fun textTransformations(
        vararg
        values: WebAclRuleStatementXssMatchStatementTextTransformationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    internal fun build(): WebAclRuleStatementXssMatchStatementArgs =
        WebAclRuleStatementXssMatchStatementArgs(
            fieldToMatch = fieldToMatch,
            textTransformations = textTransformations ?: throw PulumiNullFieldException("textTransformations"),
        )
}
