@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementXssMatchStatementFieldToMatchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allQueryArguments Inspect all query arguments.
 * @property body Inspect the request body, which immediately follows the request headers. See `body` below for details.
 * @property cookies Inspect the cookies in the web request. See `cookies` below for details.
 * @property headers Inspect the request headers. See `headers` below for details.
 * @property ja3Fingerprint Inspect the JA3 fingerprint. See `ja3_fingerprint` below for details.
 * @property jsonBody Inspect the request body as JSON. See `json_body` for details.
 * @property method Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
 * @property queryString Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
 * @property singleHeader Inspect a single header. See `single_header` below for details.
 * @property singleQueryArgument Inspect a single query argument. See `single_query_argument` below for details.
 * @property uriPath Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
 */
public data class WebAclRuleStatementXssMatchStatementFieldToMatchArgs(
    public val allQueryArguments:
    Output<WebAclRuleStatementXssMatchStatementFieldToMatchAllQueryArgumentsArgs>? = null,
    public val body: Output<WebAclRuleStatementXssMatchStatementFieldToMatchBodyArgs>? = null,
    public val cookies: Output<WebAclRuleStatementXssMatchStatementFieldToMatchCookiesArgs>? = null,
    public val headers: Output<List<WebAclRuleStatementXssMatchStatementFieldToMatchHeaderArgs>>? =
        null,
    public val ja3Fingerprint:
    Output<WebAclRuleStatementXssMatchStatementFieldToMatchJa3FingerprintArgs>? = null,
    public val jsonBody: Output<WebAclRuleStatementXssMatchStatementFieldToMatchJsonBodyArgs>? = null,
    public val method: Output<WebAclRuleStatementXssMatchStatementFieldToMatchMethodArgs>? = null,
    public val queryString: Output<WebAclRuleStatementXssMatchStatementFieldToMatchQueryStringArgs>? =
        null,
    public val singleHeader: Output<WebAclRuleStatementXssMatchStatementFieldToMatchSingleHeaderArgs>? =
        null,
    public val singleQueryArgument:
    Output<WebAclRuleStatementXssMatchStatementFieldToMatchSingleQueryArgumentArgs>? = null,
    public val uriPath: Output<WebAclRuleStatementXssMatchStatementFieldToMatchUriPathArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementXssMatchStatementFieldToMatchArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementXssMatchStatementFieldToMatchArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementXssMatchStatementFieldToMatchArgs.builder()
            .allQueryArguments(allQueryArguments?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .body(body?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .cookies(cookies?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .headers(
                headers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ja3Fingerprint(ja3Fingerprint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .jsonBody(jsonBody?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .method(method?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .queryString(queryString?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .singleHeader(singleHeader?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .singleQueryArgument(
                singleQueryArgument?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .uriPath(uriPath?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [WebAclRuleStatementXssMatchStatementFieldToMatchArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementXssMatchStatementFieldToMatchArgsBuilder internal constructor() {
    private var allQueryArguments:
        Output<WebAclRuleStatementXssMatchStatementFieldToMatchAllQueryArgumentsArgs>? = null

    private var body: Output<WebAclRuleStatementXssMatchStatementFieldToMatchBodyArgs>? = null

    private var cookies: Output<WebAclRuleStatementXssMatchStatementFieldToMatchCookiesArgs>? = null

    private var headers: Output<List<WebAclRuleStatementXssMatchStatementFieldToMatchHeaderArgs>>? =
        null

    private var ja3Fingerprint:
        Output<WebAclRuleStatementXssMatchStatementFieldToMatchJa3FingerprintArgs>? = null

    private var jsonBody: Output<WebAclRuleStatementXssMatchStatementFieldToMatchJsonBodyArgs>? = null

    private var method: Output<WebAclRuleStatementXssMatchStatementFieldToMatchMethodArgs>? = null

    private var queryString: Output<WebAclRuleStatementXssMatchStatementFieldToMatchQueryStringArgs>? =
        null

    private var singleHeader:
        Output<WebAclRuleStatementXssMatchStatementFieldToMatchSingleHeaderArgs>? = null

    private var singleQueryArgument:
        Output<WebAclRuleStatementXssMatchStatementFieldToMatchSingleQueryArgumentArgs>? = null

    private var uriPath: Output<WebAclRuleStatementXssMatchStatementFieldToMatchUriPathArgs>? = null

    /**
     * @param value Inspect all query arguments.
     */
    @JvmName("opfgpowkyjoagfmm")
    public suspend
    fun allQueryArguments(`value`: Output<WebAclRuleStatementXssMatchStatementFieldToMatchAllQueryArgumentsArgs>) {
        this.allQueryArguments = value
    }

    /**
     * @param value Inspect the request body, which immediately follows the request headers. See `body` below for details.
     */
    @JvmName("ckpsometarkgfbao")
    public suspend
    fun body(`value`: Output<WebAclRuleStatementXssMatchStatementFieldToMatchBodyArgs>) {
        this.body = value
    }

    /**
     * @param value Inspect the cookies in the web request. See `cookies` below for details.
     */
    @JvmName("dlmeluoxcvbmfnnv")
    public suspend
    fun cookies(`value`: Output<WebAclRuleStatementXssMatchStatementFieldToMatchCookiesArgs>) {
        this.cookies = value
    }

    /**
     * @param value Inspect the request headers. See `headers` below for details.
     */
    @JvmName("fsfywyyhtoqkergq")
    public suspend
    fun headers(`value`: Output<List<WebAclRuleStatementXssMatchStatementFieldToMatchHeaderArgs>>) {
        this.headers = value
    }

    @JvmName("mqksxtttyymxncpf")
    public suspend fun headers(
        vararg
        values: Output<WebAclRuleStatementXssMatchStatementFieldToMatchHeaderArgs>,
    ) {
        this.headers = Output.all(values.asList())
    }

    /**
     * @param values Inspect the request headers. See `headers` below for details.
     */
    @JvmName("jfpwlqprmnkixirq")
    public suspend
    fun headers(values: List<Output<WebAclRuleStatementXssMatchStatementFieldToMatchHeaderArgs>>) {
        this.headers = Output.all(values)
    }

    /**
     * @param value Inspect the JA3 fingerprint. See `ja3_fingerprint` below for details.
     */
    @JvmName("dhhbkwsigbpiddvr")
    public suspend
    fun ja3Fingerprint(`value`: Output<WebAclRuleStatementXssMatchStatementFieldToMatchJa3FingerprintArgs>) {
        this.ja3Fingerprint = value
    }

    /**
     * @param value Inspect the request body as JSON. See `json_body` for details.
     */
    @JvmName("xbeiwnrjckxqefia")
    public suspend
    fun jsonBody(`value`: Output<WebAclRuleStatementXssMatchStatementFieldToMatchJsonBodyArgs>) {
        this.jsonBody = value
    }

    /**
     * @param value Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("kppnheikucdcspkx")
    public suspend
    fun method(`value`: Output<WebAclRuleStatementXssMatchStatementFieldToMatchMethodArgs>) {
        this.method = value
    }

    /**
     * @param value Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("yqfwcxeyuurheksg")
    public suspend
    fun queryString(`value`: Output<WebAclRuleStatementXssMatchStatementFieldToMatchQueryStringArgs>) {
        this.queryString = value
    }

    /**
     * @param value Inspect a single header. See `single_header` below for details.
     */
    @JvmName("lpgaolhnvsfsgkvy")
    public suspend
    fun singleHeader(`value`: Output<WebAclRuleStatementXssMatchStatementFieldToMatchSingleHeaderArgs>) {
        this.singleHeader = value
    }

    /**
     * @param value Inspect a single query argument. See `single_query_argument` below for details.
     */
    @JvmName("exnxuoyhkobookhw")
    public suspend
    fun singleQueryArgument(`value`: Output<WebAclRuleStatementXssMatchStatementFieldToMatchSingleQueryArgumentArgs>) {
        this.singleQueryArgument = value
    }

    /**
     * @param value Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("vregguwghvtctynw")
    public suspend
    fun uriPath(`value`: Output<WebAclRuleStatementXssMatchStatementFieldToMatchUriPathArgs>) {
        this.uriPath = value
    }

    /**
     * @param value Inspect all query arguments.
     */
    @JvmName("tsdehlcbvjnmnemy")
    public suspend
    fun allQueryArguments(`value`: WebAclRuleStatementXssMatchStatementFieldToMatchAllQueryArgumentsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allQueryArguments = mapped
    }

    /**
     * @param argument Inspect all query arguments.
     */
    @JvmName("tywcllftyukgarad")
    public suspend
    fun allQueryArguments(argument: suspend WebAclRuleStatementXssMatchStatementFieldToMatchAllQueryArgumentsArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementXssMatchStatementFieldToMatchAllQueryArgumentsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.allQueryArguments = mapped
    }

    /**
     * @param value Inspect the request body, which immediately follows the request headers. See `body` below for details.
     */
    @JvmName("qorxryhmahipgitf")
    public suspend fun body(`value`: WebAclRuleStatementXssMatchStatementFieldToMatchBodyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.body = mapped
    }

    /**
     * @param argument Inspect the request body, which immediately follows the request headers. See `body` below for details.
     */
    @JvmName("lyuesodbosepmhhu")
    public suspend
    fun body(argument: suspend WebAclRuleStatementXssMatchStatementFieldToMatchBodyArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleStatementXssMatchStatementFieldToMatchBodyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.body = mapped
    }

    /**
     * @param value Inspect the cookies in the web request. See `cookies` below for details.
     */
    @JvmName("nmeysbfofoomtruf")
    public suspend
    fun cookies(`value`: WebAclRuleStatementXssMatchStatementFieldToMatchCookiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cookies = mapped
    }

    /**
     * @param argument Inspect the cookies in the web request. See `cookies` below for details.
     */
    @JvmName("yisqfojrdbtvhbdv")
    public suspend
    fun cookies(argument: suspend WebAclRuleStatementXssMatchStatementFieldToMatchCookiesArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementXssMatchStatementFieldToMatchCookiesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.cookies = mapped
    }

    /**
     * @param value Inspect the request headers. See `headers` below for details.
     */
    @JvmName("ofpiwblamprhnyck")
    public suspend
    fun headers(`value`: List<WebAclRuleStatementXssMatchStatementFieldToMatchHeaderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See `headers` below for details.
     */
    @JvmName("nfmwufkjvuysdmts")
    public suspend
    fun headers(argument: List<suspend WebAclRuleStatementXssMatchStatementFieldToMatchHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementXssMatchStatementFieldToMatchHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See `headers` below for details.
     */
    @JvmName("qxbagvhcfnbcohhk")
    public suspend fun headers(
        vararg
        argument: suspend WebAclRuleStatementXssMatchStatementFieldToMatchHeaderArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementXssMatchStatementFieldToMatchHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See `headers` below for details.
     */
    @JvmName("icujhsocdslkidwc")
    public suspend
    fun headers(argument: suspend WebAclRuleStatementXssMatchStatementFieldToMatchHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclRuleStatementXssMatchStatementFieldToMatchHeaderArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param values Inspect the request headers. See `headers` below for details.
     */
    @JvmName("mwauycwoeoykiuwg")
    public suspend fun headers(
        vararg
        values: WebAclRuleStatementXssMatchStatementFieldToMatchHeaderArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param value Inspect the JA3 fingerprint. See `ja3_fingerprint` below for details.
     */
    @JvmName("mqygrlorkpjunrjv")
    public suspend
    fun ja3Fingerprint(`value`: WebAclRuleStatementXssMatchStatementFieldToMatchJa3FingerprintArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ja3Fingerprint = mapped
    }

    /**
     * @param argument Inspect the JA3 fingerprint. See `ja3_fingerprint` below for details.
     */
    @JvmName("xmegavxmqyebecdp")
    public suspend
    fun ja3Fingerprint(argument: suspend WebAclRuleStatementXssMatchStatementFieldToMatchJa3FingerprintArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementXssMatchStatementFieldToMatchJa3FingerprintArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ja3Fingerprint = mapped
    }

    /**
     * @param value Inspect the request body as JSON. See `json_body` for details.
     */
    @JvmName("ufcfdgbggngnxkhh")
    public suspend
    fun jsonBody(`value`: WebAclRuleStatementXssMatchStatementFieldToMatchJsonBodyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jsonBody = mapped
    }

    /**
     * @param argument Inspect the request body as JSON. See `json_body` for details.
     */
    @JvmName("quoyneakkcnjjrad")
    public suspend
    fun jsonBody(argument: suspend WebAclRuleStatementXssMatchStatementFieldToMatchJsonBodyArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementXssMatchStatementFieldToMatchJsonBodyArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.jsonBody = mapped
    }

    /**
     * @param value Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("skoupikxiwpwestt")
    public suspend fun method(`value`: WebAclRuleStatementXssMatchStatementFieldToMatchMethodArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param argument Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("xcrlofpnohckwyeg")
    public suspend
    fun method(argument: suspend WebAclRuleStatementXssMatchStatementFieldToMatchMethodArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementXssMatchStatementFieldToMatchMethodArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.method = mapped
    }

    /**
     * @param value Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("aldvdnkbkycwrypx")
    public suspend
    fun queryString(`value`: WebAclRuleStatementXssMatchStatementFieldToMatchQueryStringArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryString = mapped
    }

    /**
     * @param argument Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("wivdmdoskapawsgt")
    public suspend
    fun queryString(argument: suspend WebAclRuleStatementXssMatchStatementFieldToMatchQueryStringArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementXssMatchStatementFieldToMatchQueryStringArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.queryString = mapped
    }

    /**
     * @param value Inspect a single header. See `single_header` below for details.
     */
    @JvmName("bawjvlmeggbmjuvj")
    public suspend
    fun singleHeader(`value`: WebAclRuleStatementXssMatchStatementFieldToMatchSingleHeaderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleHeader = mapped
    }

    /**
     * @param argument Inspect a single header. See `single_header` below for details.
     */
    @JvmName("dopvddjupalidkge")
    public suspend
    fun singleHeader(argument: suspend WebAclRuleStatementXssMatchStatementFieldToMatchSingleHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementXssMatchStatementFieldToMatchSingleHeaderArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.singleHeader = mapped
    }

    /**
     * @param value Inspect a single query argument. See `single_query_argument` below for details.
     */
    @JvmName("wymtjjynltajdmkp")
    public suspend
    fun singleQueryArgument(`value`: WebAclRuleStatementXssMatchStatementFieldToMatchSingleQueryArgumentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleQueryArgument = mapped
    }

    /**
     * @param argument Inspect a single query argument. See `single_query_argument` below for details.
     */
    @JvmName("biwnejcwitrgjfxj")
    public suspend
    fun singleQueryArgument(argument: suspend WebAclRuleStatementXssMatchStatementFieldToMatchSingleQueryArgumentArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementXssMatchStatementFieldToMatchSingleQueryArgumentArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.singleQueryArgument = mapped
    }

    /**
     * @param value Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("xkmuyfgvjxhvsivi")
    public suspend
    fun uriPath(`value`: WebAclRuleStatementXssMatchStatementFieldToMatchUriPathArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uriPath = mapped
    }

    /**
     * @param argument Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("qrtoaofgpfiqdwev")
    public suspend
    fun uriPath(argument: suspend WebAclRuleStatementXssMatchStatementFieldToMatchUriPathArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementXssMatchStatementFieldToMatchUriPathArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.uriPath = mapped
    }

    internal fun build(): WebAclRuleStatementXssMatchStatementFieldToMatchArgs =
        WebAclRuleStatementXssMatchStatementFieldToMatchArgs(
            allQueryArguments = allQueryArguments,
            body = body,
            cookies = cookies,
            headers = headers,
            ja3Fingerprint = ja3Fingerprint,
            jsonBody = jsonBody,
            method = method,
            queryString = queryString,
            singleHeader = singleHeader,
            singleQueryArgument = singleQueryArgument,
            uriPath = uriPath,
        )
}
