@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementXssMatchStatementFieldToMatchJsonBodyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property invalidFallbackBehavior What to do when JSON parsing fails. Defaults to evaluating up to the first parsing failure. Valid values are `EVALUATE_AS_STRING`, `MATCH` and `NO_MATCH`.
 * @property matchPattern The patterns to look for in the JSON body. You must specify exactly one setting: either `all` or `included_paths`. See [JsonMatchPattern](https://docs.aws.amazon.com/waf/latest/APIReference/API_JsonMatchPattern.html) for details.
 * @property matchScope The parts of the JSON to match against using the `match_pattern`. Valid values are `ALL`, `KEY` and `VALUE`.
 * @property oversizeHandling What to do if the body is larger than can be inspected. Valid values are `CONTINUE` (default), `MATCH` and `NO_MATCH`.
 */
public data class WebAclRuleStatementXssMatchStatementFieldToMatchJsonBodyArgs(
    public val invalidFallbackBehavior: Output<String>? = null,
    public val matchPattern:
    Output<WebAclRuleStatementXssMatchStatementFieldToMatchJsonBodyMatchPatternArgs>,
    public val matchScope: Output<String>,
    public val oversizeHandling: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementXssMatchStatementFieldToMatchJsonBodyArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementXssMatchStatementFieldToMatchJsonBodyArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementXssMatchStatementFieldToMatchJsonBodyArgs.builder()
            .invalidFallbackBehavior(invalidFallbackBehavior?.applyValue({ args0 -> args0 }))
            .matchPattern(matchPattern.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .matchScope(matchScope.applyValue({ args0 -> args0 }))
            .oversizeHandling(oversizeHandling?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAclRuleStatementXssMatchStatementFieldToMatchJsonBodyArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementXssMatchStatementFieldToMatchJsonBodyArgsBuilder internal
constructor() {
    private var invalidFallbackBehavior: Output<String>? = null

    private var matchPattern:
        Output<WebAclRuleStatementXssMatchStatementFieldToMatchJsonBodyMatchPatternArgs>? = null

    private var matchScope: Output<String>? = null

    private var oversizeHandling: Output<String>? = null

    /**
     * @param value What to do when JSON parsing fails. Defaults to evaluating up to the first parsing failure. Valid values are `EVALUATE_AS_STRING`, `MATCH` and `NO_MATCH`.
     */
    @JvmName("rgvrdgcrumxaxlwv")
    public suspend fun invalidFallbackBehavior(`value`: Output<String>) {
        this.invalidFallbackBehavior = value
    }

    /**
     * @param value The patterns to look for in the JSON body. You must specify exactly one setting: either `all` or `included_paths`. See [JsonMatchPattern](https://docs.aws.amazon.com/waf/latest/APIReference/API_JsonMatchPattern.html) for details.
     */
    @JvmName("bjbstuqkfuiqvcdf")
    public suspend
    fun matchPattern(`value`: Output<WebAclRuleStatementXssMatchStatementFieldToMatchJsonBodyMatchPatternArgs>) {
        this.matchPattern = value
    }

    /**
     * @param value The parts of the JSON to match against using the `match_pattern`. Valid values are `ALL`, `KEY` and `VALUE`.
     */
    @JvmName("lsplhyujspsngxhh")
    public suspend fun matchScope(`value`: Output<String>) {
        this.matchScope = value
    }

    /**
     * @param value What to do if the body is larger than can be inspected. Valid values are `CONTINUE` (default), `MATCH` and `NO_MATCH`.
     */
    @JvmName("ktxlnhnvgpaypast")
    public suspend fun oversizeHandling(`value`: Output<String>) {
        this.oversizeHandling = value
    }

    /**
     * @param value What to do when JSON parsing fails. Defaults to evaluating up to the first parsing failure. Valid values are `EVALUATE_AS_STRING`, `MATCH` and `NO_MATCH`.
     */
    @JvmName("ssrlkkgcghcqxlqq")
    public suspend fun invalidFallbackBehavior(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.invalidFallbackBehavior = mapped
    }

    /**
     * @param value The patterns to look for in the JSON body. You must specify exactly one setting: either `all` or `included_paths`. See [JsonMatchPattern](https://docs.aws.amazon.com/waf/latest/APIReference/API_JsonMatchPattern.html) for details.
     */
    @JvmName("fqawjapcrmnuwbwx")
    public suspend
    fun matchPattern(`value`: WebAclRuleStatementXssMatchStatementFieldToMatchJsonBodyMatchPatternArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchPattern = mapped
    }

    /**
     * @param argument The patterns to look for in the JSON body. You must specify exactly one setting: either `all` or `included_paths`. See [JsonMatchPattern](https://docs.aws.amazon.com/waf/latest/APIReference/API_JsonMatchPattern.html) for details.
     */
    @JvmName("xxitmgwrrtxoleyi")
    public suspend
    fun matchPattern(argument: suspend WebAclRuleStatementXssMatchStatementFieldToMatchJsonBodyMatchPatternArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementXssMatchStatementFieldToMatchJsonBodyMatchPatternArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.matchPattern = mapped
    }

    /**
     * @param value The parts of the JSON to match against using the `match_pattern`. Valid values are `ALL`, `KEY` and `VALUE`.
     */
    @JvmName("twlbsjhmwoqxpddp")
    public suspend fun matchScope(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchScope = mapped
    }

    /**
     * @param value What to do if the body is larger than can be inspected. Valid values are `CONTINUE` (default), `MATCH` and `NO_MATCH`.
     */
    @JvmName("jnqikajgsmgvycfm")
    public suspend fun oversizeHandling(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oversizeHandling = mapped
    }

    internal fun build(): WebAclRuleStatementXssMatchStatementFieldToMatchJsonBodyArgs =
        WebAclRuleStatementXssMatchStatementFieldToMatchJsonBodyArgs(
            invalidFallbackBehavior = invalidFallbackBehavior,
            matchPattern = matchPattern ?: throw PulumiNullFieldException("matchPattern"),
            matchScope = matchScope ?: throw PulumiNullFieldException("matchScope"),
            oversizeHandling = oversizeHandling,
        )
}
