@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleVisibilityConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cloudwatchMetricsEnabled Whether the associated resource sends metrics to CloudWatch. For the list of available metrics, see [AWS WAF Metrics](https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#waf-metrics).
 * @property metricName A friendly name of the CloudWatch metric. The name can contain only alphanumeric characters (A-Z, a-z, 0-9) hyphen(-) and underscore (\_), with length from one to 128 characters. It can't contain whitespace or metric names reserved for AWS WAF, for example `All` and `Default_Action`.
 * @property sampledRequestsEnabled Whether AWS WAF should store a sampling of the web requests that match the rules. You can view the sampled requests through the AWS WAF console.
 */
public data class WebAclRuleVisibilityConfigArgs(
    public val cloudwatchMetricsEnabled: Output<Boolean>,
    public val metricName: Output<String>,
    public val sampledRequestsEnabled: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleVisibilityConfigArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleVisibilityConfigArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleVisibilityConfigArgs.builder()
            .cloudwatchMetricsEnabled(cloudwatchMetricsEnabled.applyValue({ args0 -> args0 }))
            .metricName(metricName.applyValue({ args0 -> args0 }))
            .sampledRequestsEnabled(sampledRequestsEnabled.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAclRuleVisibilityConfigArgs].
 */
@PulumiTagMarker
public class WebAclRuleVisibilityConfigArgsBuilder internal constructor() {
    private var cloudwatchMetricsEnabled: Output<Boolean>? = null

    private var metricName: Output<String>? = null

    private var sampledRequestsEnabled: Output<Boolean>? = null

    /**
     * @param value Whether the associated resource sends metrics to CloudWatch. For the list of available metrics, see [AWS WAF Metrics](https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#waf-metrics).
     */
    @JvmName("ckynaqgefxspuipw")
    public suspend fun cloudwatchMetricsEnabled(`value`: Output<Boolean>) {
        this.cloudwatchMetricsEnabled = value
    }

    /**
     * @param value A friendly name of the CloudWatch metric. The name can contain only alphanumeric characters (A-Z, a-z, 0-9) hyphen(-) and underscore (\_), with length from one to 128 characters. It can't contain whitespace or metric names reserved for AWS WAF, for example `All` and `Default_Action`.
     */
    @JvmName("kjeedkpxeddbqnbk")
    public suspend fun metricName(`value`: Output<String>) {
        this.metricName = value
    }

    /**
     * @param value Whether AWS WAF should store a sampling of the web requests that match the rules. You can view the sampled requests through the AWS WAF console.
     */
    @JvmName("vrbwwotgokerpdvl")
    public suspend fun sampledRequestsEnabled(`value`: Output<Boolean>) {
        this.sampledRequestsEnabled = value
    }

    /**
     * @param value Whether the associated resource sends metrics to CloudWatch. For the list of available metrics, see [AWS WAF Metrics](https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#waf-metrics).
     */
    @JvmName("lncefybmewwwxkqv")
    public suspend fun cloudwatchMetricsEnabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cloudwatchMetricsEnabled = mapped
    }

    /**
     * @param value A friendly name of the CloudWatch metric. The name can contain only alphanumeric characters (A-Z, a-z, 0-9) hyphen(-) and underscore (\_), with length from one to 128 characters. It can't contain whitespace or metric names reserved for AWS WAF, for example `All` and `Default_Action`.
     */
    @JvmName("cjrbsslsfgikqqga")
    public suspend fun metricName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricName = mapped
    }

    /**
     * @param value Whether AWS WAF should store a sampling of the web requests that match the rules. You can view the sampled requests through the AWS WAF console.
     */
    @JvmName("fokjgmwhebdohnmt")
    public suspend fun sampledRequestsEnabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sampledRequestsEnabled = mapped
    }

    internal fun build(): WebAclRuleVisibilityConfigArgs = WebAclRuleVisibilityConfigArgs(
        cloudwatchMetricsEnabled = cloudwatchMetricsEnabled ?: throw
            PulumiNullFieldException("cloudwatchMetricsEnabled"),
        metricName = metricName ?: throw PulumiNullFieldException("metricName"),
        sampledRequestsEnabled = sampledRequestsEnabled ?: throw
            PulumiNullFieldException("sampledRequestsEnabled"),
    )
}
