@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getIpSet.
 * @property addresses An array of strings that specifies zero or more IP addresses or blocks of IP addresses in Classless Inter-Domain Routing (CIDR) notation.
 * @property arn ARN of the entity.
 * @property description Description of the set that helps with identification.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ipAddressVersion IP address version of the set.
 * @property name
 * @property scope
 */
public data class GetIpSetResult(
    public val addresses: List<String>,
    public val arn: String,
    public val description: String,
    public val id: String,
    public val ipAddressVersion: String,
    public val name: String,
    public val scope: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.GetIpSetResult): GetIpSetResult =
            GetIpSetResult(
                addresses = javaType.addresses().map({ args0 -> args0 }),
                arn = javaType.arn(),
                description = javaType.description(),
                id = javaType.id(),
                ipAddressVersion = javaType.ipAddressVersion(),
                name = javaType.name(),
                scope = javaType.scope(),
            )
    }
}
