@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getRegexPatternSet.
 * @property arn ARN of the entity.
 * @property description Description of the set that helps with identification.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 * @property regularExpressions One or more blocks of regular expression patterns that AWS WAF is searching for. See Regular Expression below for details.
 * @property scope
 */
public data class GetRegexPatternSetResult(
    public val arn: String,
    public val description: String,
    public val id: String,
    public val name: String,
    public val regularExpressions: List<GetRegexPatternSetRegularExpression>,
    public val scope: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.GetRegexPatternSetResult):
            GetRegexPatternSetResult = GetRegexPatternSetResult(
            arn = javaType.arn(),
            description = javaType.description(),
            id = javaType.id(),
            name = javaType.name(),
            regularExpressions = javaType.regularExpressions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.GetRegexPatternSetRegularExpression.Companion.toKotlin(args0)
                })
            }),
            scope = javaType.scope(),
        )
    }
}
