@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getRuleGroup.
 * @property arn ARN of the entity.
 * @property description Description of the rule group that helps with identification.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 * @property scope
 */
public data class GetRuleGroupResult(
    public val arn: String,
    public val description: String,
    public val id: String,
    public val name: String,
    public val scope: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.GetRuleGroupResult):
            GetRuleGroupResult = GetRuleGroupResult(
            arn = javaType.arn(),
            description = javaType.description(),
            id = javaType.id(),
            name = javaType.name(),
            scope = javaType.scope(),
        )
    }
}
