@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property content The payload of the custom response.
 * @property contentType The type of content in the payload that you are defining in the `content` argument. Valid values are `TEXT_PLAIN`, `TEXT_HTML`, or `APPLICATION_JSON`.
 * @property key A unique key identifying the custom response body. This is referenced by the `custom_response_body_key` argument in the Custom Response block.
 */
public data class RuleGroupCustomResponseBody(
    public val content: String,
    public val contentType: String,
    public val key: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.RuleGroupCustomResponseBody):
            RuleGroupCustomResponseBody = RuleGroupCustomResponseBody(
            content = javaType.content(),
            contentType = javaType.contentType(),
            key = javaType.key(),
        )
    }
}
