@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property aggregateKeyType Setting that indicates how to aggregate the request counts. Valid values include: `CONSTANT`, `CUSTOM_KEYS`, `FORWARDED_IP` or `IP`. Default: `IP`.
 * @property customKeys Aggregate the request counts using one or more web request components as the aggregate keys. See `custom_key` below for details.
 * @property forwardedIpConfig The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. If `aggregate_key_type` is set to `FORWARDED_IP`, this block is required. See Forwarded IP Config below for details.
 * @property limit The limit on requests per 5-minute period for a single originating IP address.
 * @property scopeDownStatement An optional nested statement that narrows the scope of the rate-based statement to matching web requests. This can be any nestable statement, and you can nest statements at any level below this scope-down statement. See Statement above for details. If `aggregate_key_type` is set to `CONSTANT`, this block is required.
 */
public data class RuleGroupRuleStatementRateBasedStatement(
    public val aggregateKeyType: String? = null,
    public val customKeys: List<RuleGroupRuleStatementRateBasedStatementCustomKey>? = null,
    public val forwardedIpConfig: RuleGroupRuleStatementRateBasedStatementForwardedIpConfig? = null,
    public val limit: Int,
    public val scopeDownStatement: RuleGroupRuleStatementRateBasedStatementScopeDownStatement? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.RuleGroupRuleStatementRateBasedStatement):
            RuleGroupRuleStatementRateBasedStatement = RuleGroupRuleStatementRateBasedStatement(
            aggregateKeyType = javaType.aggregateKeyType().map({ args0 -> args0 }).orElse(null),
            customKeys = javaType.customKeys().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRateBasedStatementCustomKey.Companion.toKotlin(args0)
                })
            }),
            forwardedIpConfig = javaType.forwardedIpConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRateBasedStatementForwardedIpConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            limit = javaType.limit(),
            scopeDownStatement = javaType.scopeDownStatement().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatement.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
