@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property cookie (Optional) Use the value of a cookie in the request as an aggregate key. See RateLimit `cookie` below for details.
 * @property forwardedIp (Optional) Use the first IP address in an HTTP header as an aggregate key. See `forwarded_ip` below for details.
 * @property header (Optional) Use the value of a header in the request as an aggregate key. See RateLimit `header` below for details.
 * @property httpMethod (Optional) Use the request's HTTP method as an aggregate key. See RateLimit `http_method` below for details.
 * @property ip (Optional) Use the request's originating IP address as an aggregate key. See `RateLimit ip` below for details.
 * @property labelNamespace (Optional) Use the specified label namespace as an aggregate key. See RateLimit `label_namespace` below for details.
 * @property queryArgument (Optional) Use the specified query argument as an aggregate key. See RateLimit `query_argument` below for details.
 * @property queryString Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
 * @property uriPath Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
 */
public data class RuleGroupRuleStatementRateBasedStatementCustomKey(
    public val cookie: RuleGroupRuleStatementRateBasedStatementCustomKeyCookie? = null,
    public val forwardedIp: RuleGroupRuleStatementRateBasedStatementCustomKeyForwardedIp? = null,
    public val `header`: RuleGroupRuleStatementRateBasedStatementCustomKeyHeader? = null,
    public val httpMethod: RuleGroupRuleStatementRateBasedStatementCustomKeyHttpMethod? = null,
    public val ip: RuleGroupRuleStatementRateBasedStatementCustomKeyIp? = null,
    public val labelNamespace: RuleGroupRuleStatementRateBasedStatementCustomKeyLabelNamespace? =
        null,
    public val queryArgument: RuleGroupRuleStatementRateBasedStatementCustomKeyQueryArgument? = null,
    public val queryString: RuleGroupRuleStatementRateBasedStatementCustomKeyQueryString? = null,
    public val uriPath: RuleGroupRuleStatementRateBasedStatementCustomKeyUriPath? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.RuleGroupRuleStatementRateBasedStatementCustomKey):
            RuleGroupRuleStatementRateBasedStatementCustomKey =
            RuleGroupRuleStatementRateBasedStatementCustomKey(
                cookie = javaType.cookie().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRateBasedStatementCustomKeyCookie.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                forwardedIp = javaType.forwardedIp().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRateBasedStatementCustomKeyForwardedIp.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                `header` = javaType.`header`().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRateBasedStatementCustomKeyHeader.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                httpMethod = javaType.httpMethod().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRateBasedStatementCustomKeyHttpMethod.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                ip = javaType.ip().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRateBasedStatementCustomKeyIp.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                labelNamespace = javaType.labelNamespace().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRateBasedStatementCustomKeyLabelNamespace.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                queryArgument = javaType.queryArgument().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRateBasedStatementCustomKeyQueryArgument.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                queryString = javaType.queryString().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRateBasedStatementCustomKeyQueryString.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                uriPath = javaType.uriPath().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRateBasedStatementCustomKeyUriPath.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
