@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property name A friendly name of the rule group.
 * @property textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
 * At least one required.
 * See Text Transformation below for details.
 */
public data class RuleGroupRuleStatementRateBasedStatementCustomKeyCookie(
    public val name: String,
    public val textTransformations:
    List<RuleGroupRuleStatementRateBasedStatementCustomKeyCookieTextTransformation>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.RuleGroupRuleStatementRateBasedStatementCustomKeyCookie):
            RuleGroupRuleStatementRateBasedStatementCustomKeyCookie =
            RuleGroupRuleStatementRateBasedStatementCustomKeyCookie(
                name = javaType.name(),
                textTransformations = javaType.textTransformations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRateBasedStatementCustomKeyCookieTextTransformation.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
