@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property andStatement A logical rule statement used to combine other rule statements with AND logic. See AND Statement below for details.
 * @property byteMatchStatement A rule statement that defines a string match search for AWS WAF to apply to web requests. See Byte Match Statement below for details.
 * @property geoMatchStatement A rule statement used to identify web requests based on country of origin. See GEO Match Statement below for details.
 * @property ipSetReferenceStatement A rule statement used to detect web requests coming from particular IP addresses or address ranges. See IP Set Reference Statement below for details.
 * @property labelMatchStatement A rule statement that defines a string match search against labels that have been added to the web request by rules that have already run in the web ACL. See Label Match Statement below for details.
 * @property notStatement A logical rule statement used to negate the results of another rule statement. See NOT Statement below for details.
 * @property orStatement A logical rule statement used to combine other rule statements with OR logic. See OR Statement below for details.
 * @property regexMatchStatement A rule statement used to search web request components for a match against a single regular expression. See Regex Match Statement below for details.
 * @property regexPatternSetReferenceStatement A rule statement used to search web request components for matches with regular expressions. See Regex Pattern Set Reference Statement below for details.
 * @property sizeConstraintStatement A rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<). See Size Constraint Statement below for more details.
 * @property sqliMatchStatement An SQL injection match condition identifies the part of web requests, such as the URI or the query string, that you want AWS WAF to inspect. See SQL Injection Match Statement below for details.
 * @property xssMatchStatement A rule statement that defines a cross-site scripting (XSS) match search for AWS WAF to apply to web requests. See XSS Match Statement below for details.
 */
public data class RuleGroupRuleStatementRateBasedStatementScopeDownStatement(
    public val andStatement: RuleGroupRuleStatementRateBasedStatementScopeDownStatementAndStatement? =
        null,
    public val byteMatchStatement:
    RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatement? = null,
    public val geoMatchStatement:
    RuleGroupRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatement? = null,
    public val ipSetReferenceStatement:
    RuleGroupRuleStatementRateBasedStatementScopeDownStatementIpSetReferenceStatement? = null,
    public val labelMatchStatement:
    RuleGroupRuleStatementRateBasedStatementScopeDownStatementLabelMatchStatement? = null,
    public val notStatement: RuleGroupRuleStatementRateBasedStatementScopeDownStatementNotStatement? =
        null,
    public val orStatement: RuleGroupRuleStatementRateBasedStatementScopeDownStatementOrStatement? =
        null,
    public val regexMatchStatement:
    RuleGroupRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatement? = null,
    public val regexPatternSetReferenceStatement:
    RuleGroupRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatement? =
        null,
    public val sizeConstraintStatement:
    RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatement? = null,
    public val sqliMatchStatement:
    RuleGroupRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatement? = null,
    public val xssMatchStatement:
    RuleGroupRuleStatementRateBasedStatementScopeDownStatementXssMatchStatement? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatement):
            RuleGroupRuleStatementRateBasedStatementScopeDownStatement =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatement(
                andStatement = javaType.andStatement().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementAndStatement.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                byteMatchStatement = javaType.byteMatchStatement().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatement.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                geoMatchStatement = javaType.geoMatchStatement().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatement.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                ipSetReferenceStatement = javaType.ipSetReferenceStatement().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementIpSetReferenceStatement.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                labelMatchStatement = javaType.labelMatchStatement().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementLabelMatchStatement.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                notStatement = javaType.notStatement().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementNotStatement.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                orStatement = javaType.orStatement().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementOrStatement.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                regexMatchStatement = javaType.regexMatchStatement().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatement.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                regexPatternSetReferenceStatement = javaType.regexPatternSetReferenceStatement().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatement.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                sizeConstraintStatement = javaType.sizeConstraintStatement().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatement.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                sqliMatchStatement = javaType.sqliMatchStatement().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatement.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                xssMatchStatement = javaType.xssMatchStatement().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementXssMatchStatement.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
