@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property countryCodes An array of two-character country codes, for example, [ "US", "CN" ], from the alpha-2 country ISO codes of the `ISO 3166` international standard&#46; See the [documentation](https://docs.aws.amazon.com/waf/latest/APIReference/API_GeoMatchStatement.html) for valid values.
 * @property forwardedIpConfig The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. See Forwarded IP Config below for details.
 */
public data class RuleGroupRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatement(
    public val countryCodes: List<String>,
    public val forwardedIpConfig:
    RuleGroupRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatementForwardedIpConfig? =
        null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatement):
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatement =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatement(
                countryCodes = javaType.countryCodes().map({ args0 -> args0 }),
                forwardedIpConfig = javaType.forwardedIpConfig().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatementForwardedIpConfig.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
