@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property priority The relative processing order for multiple transformations that are defined for a rule statement. AWS WAF processes all transformations, from lowest priority to highest, before inspecting the transformed content.
 * @property type The transformation to apply, please refer to the Text Transformation [documentation](https://docs.aws.amazon.com/waf/latest/APIReference/API_TextTransformation.html) for more details.
 */
public data class
RuleGroupRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementTextTransformation(
    public val priority: Int,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementTextTransformation):
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementTextTransformation =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementTextTransformation(
                priority = javaType.priority(),
                type = javaType.type(),
            )
    }
}
