@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property allQueryArguments Inspect all query arguments.
 * @property body Inspect the request body, which immediately follows the request headers.
 * @property cookies Inspect the cookies in the web request. See Cookies below for details.
 * @property headers Inspect the request headers. See Headers below for details.
 * @property ja3Fingerprint
 * @property jsonBody Inspect the request body as JSON. See JSON Body for details.
 * @property method Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
 * @property queryString Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
 * @property singleHeader Inspect a single header. See Single Header below for details.
 * @property singleQueryArgument Inspect a single query argument. See Single Query Argument below for details.
 * @property uriPath Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
 */
public data class RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatch(
    public val allQueryArguments:
    RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatchAllQueryArguments? = null,
    public val body: RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatchBody? = null,
    public val cookies: RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatchCookies? =
        null,
    public val headers:
    List<RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatchHeader>? = null,
    public val ja3Fingerprint:
    RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatchJa3Fingerprint? = null,
    public val jsonBody: RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatchJsonBody? =
        null,
    public val method: RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatchMethod? =
        null,
    public val queryString:
    RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatchQueryString? = null,
    public val singleHeader:
    RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatchSingleHeader? = null,
    public val singleQueryArgument:
    RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatchSingleQueryArgument? =
        null,
    public val uriPath: RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatchUriPath? =
        null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatch):
            RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatch =
            RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatch(
                allQueryArguments = javaType.allQueryArguments().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatchAllQueryArguments.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                body = javaType.body().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatchBody.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                cookies = javaType.cookies().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatchCookies.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                headers = javaType.headers().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatchHeader.Companion.toKotlin(args0)
                    })
                }),
                ja3Fingerprint = javaType.ja3Fingerprint().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatchJa3Fingerprint.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                jsonBody = javaType.jsonBody().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatchJsonBody.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                method = javaType.method().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatchMethod.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                queryString = javaType.queryString().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatchQueryString.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                singleHeader = javaType.singleHeader().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatchSingleHeader.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                singleQueryArgument = javaType.singleQueryArgument().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatchSingleQueryArgument.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                uriPath = javaType.uriPath().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatchUriPath.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
