@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property fieldToMatch The part of a web request that you want AWS WAF to inspect. See Field to Match below for details.
 * @property textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
 * At least one required.
 * See Text Transformation below for details.
 */
public data class RuleGroupRuleStatementXssMatchStatement(
    public val fieldToMatch: RuleGroupRuleStatementXssMatchStatementFieldToMatch? = null,
    public val textTransformations: List<RuleGroupRuleStatementXssMatchStatementTextTransformation>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.RuleGroupRuleStatementXssMatchStatement):
            RuleGroupRuleStatementXssMatchStatement = RuleGroupRuleStatementXssMatchStatement(
            fieldToMatch = javaType.fieldToMatch().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementXssMatchStatementFieldToMatch.Companion.toKotlin(args0)
                })
            }).orElse(null),
            textTransformations = javaType.textTransformations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementXssMatchStatementTextTransformation.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
