@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property allQueryArguments Inspect all query arguments.
 * @property body Inspect the request body, which immediately follows the request headers.
 * @property cookies Inspect the cookies in the web request. See Cookies below for details.
 * @property headers Inspect the request headers. See Headers below for details.
 * @property ja3Fingerprint
 * @property jsonBody Inspect the request body as JSON. See JSON Body for details.
 * @property method Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
 * @property queryString Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
 * @property singleHeader Inspect a single header. See Single Header below for details.
 * @property singleQueryArgument Inspect a single query argument. See Single Query Argument below for details.
 * @property uriPath Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
 */
public data class RuleGroupRuleStatementXssMatchStatementFieldToMatch(
    public val allQueryArguments:
    RuleGroupRuleStatementXssMatchStatementFieldToMatchAllQueryArguments? = null,
    public val body: RuleGroupRuleStatementXssMatchStatementFieldToMatchBody? = null,
    public val cookies: RuleGroupRuleStatementXssMatchStatementFieldToMatchCookies? = null,
    public val headers: List<RuleGroupRuleStatementXssMatchStatementFieldToMatchHeader>? = null,
    public val ja3Fingerprint: RuleGroupRuleStatementXssMatchStatementFieldToMatchJa3Fingerprint? =
        null,
    public val jsonBody: RuleGroupRuleStatementXssMatchStatementFieldToMatchJsonBody? = null,
    public val method: RuleGroupRuleStatementXssMatchStatementFieldToMatchMethod? = null,
    public val queryString: RuleGroupRuleStatementXssMatchStatementFieldToMatchQueryString? = null,
    public val singleHeader: RuleGroupRuleStatementXssMatchStatementFieldToMatchSingleHeader? = null,
    public val singleQueryArgument:
    RuleGroupRuleStatementXssMatchStatementFieldToMatchSingleQueryArgument? = null,
    public val uriPath: RuleGroupRuleStatementXssMatchStatementFieldToMatchUriPath? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.RuleGroupRuleStatementXssMatchStatementFieldToMatch):
            RuleGroupRuleStatementXssMatchStatementFieldToMatch =
            RuleGroupRuleStatementXssMatchStatementFieldToMatch(
                allQueryArguments = javaType.allQueryArguments().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementXssMatchStatementFieldToMatchAllQueryArguments.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                body = javaType.body().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementXssMatchStatementFieldToMatchBody.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                cookies = javaType.cookies().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementXssMatchStatementFieldToMatchCookies.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                headers = javaType.headers().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementXssMatchStatementFieldToMatchHeader.Companion.toKotlin(args0)
                    })
                }),
                ja3Fingerprint = javaType.ja3Fingerprint().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementXssMatchStatementFieldToMatchJa3Fingerprint.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                jsonBody = javaType.jsonBody().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementXssMatchStatementFieldToMatchJsonBody.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                method = javaType.method().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementXssMatchStatementFieldToMatchMethod.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                queryString = javaType.queryString().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementXssMatchStatementFieldToMatchQueryString.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                singleHeader = javaType.singleHeader().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementXssMatchStatementFieldToMatchSingleHeader.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                singleQueryArgument = javaType.singleQueryArgument().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementXssMatchStatementFieldToMatchSingleQueryArgument.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                uriPath = javaType.uriPath().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementXssMatchStatementFieldToMatchUriPath.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
