@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property content Payload of the custom response.
 * @property contentType Type of content in the payload that you are defining in the `content` argument. Valid values are `TEXT_PLAIN`, `TEXT_HTML`, or `APPLICATION_JSON`.
 * @property key Unique key identifying the custom response body. This is referenced by the `custom_response_body_key` argument in the `custom_response` block.
 */
public data class WebAclCustomResponseBody(
    public val content: String,
    public val contentType: String,
    public val key: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.WebAclCustomResponseBody):
            WebAclCustomResponseBody = WebAclCustomResponseBody(
            content = javaType.content(),
            contentType = javaType.contentType(),
            key = javaType.key(),
        )
    }
}
