@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property allow Specifies that AWS WAF should allow requests by default. See `allow` below for details.
 * @property block Specifies that AWS WAF should block requests by default. See `block` below for details.
 */
public data class WebAclDefaultAction(
    public val allow: WebAclDefaultActionAllow? = null,
    public val block: WebAclDefaultActionBlock? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.WebAclDefaultAction):
            WebAclDefaultAction = WebAclDefaultAction(
            allow = javaType.allow().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclDefaultActionAllow.Companion.toKotlin(args0)
                })
            }).orElse(null),
            block = javaType.block().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclDefaultActionBlock.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
