@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property defaultBehavior Default handling for logs that don't match any of the specified filtering conditions. Valid values for `default_behavior` are `KEEP` or `DROP`.
 * @property filters Filter(s) that you want to apply to the logs. See Filter below for more details.
 */
public data class WebAclLoggingConfigurationLoggingFilter(
    public val defaultBehavior: String,
    public val filters: List<WebAclLoggingConfigurationLoggingFilterFilter>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.WebAclLoggingConfigurationLoggingFilter):
            WebAclLoggingConfigurationLoggingFilter = WebAclLoggingConfigurationLoggingFilter(
            defaultBehavior = javaType.defaultBehavior(),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclLoggingConfigurationLoggingFilterFilter.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
