@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property action Action that AWS WAF should take on a web request when it matches the rule's statement. This is used only for rules whose **statements do not reference a rule group**. See `action` for details.
 * @property captchaConfig Specifies how AWS WAF should handle CAPTCHA evaluations. See `captcha_config` below for details.
 * @property name Friendly name of the rule. Note that the provider assumes that rules with names matching this pattern, `^ShieldMitigationRuleGroup_<account-id>_<web-acl-guid>_.*`, are AWS-added for [automatic application layer DDoS mitigation activities](https://docs.aws.amazon.com/waf/latest/developerguide/ddos-automatic-app-layer-response-rg.html). Such rules will be ignored by the provider unless you explicitly include them in your configuration (for example, by using the AWS CLI to discover their properties and creating matching configuration). However, since these rules are owned and managed by AWS, you may get permission errors.
 * @property overrideAction Override action to apply to the rules in a rule group. Used only for rule **statements that reference a rule group**, like `rule_group_reference_statement` and `managed_rule_group_statement`. See `override_action` below for details.
 * @property priority If you define more than one Rule in a WebACL, AWS WAF evaluates each request against the `rules` in order based on the value of `priority`. AWS WAF processes rules with lower priority first.
 * @property ruleLabels Labels to apply to web requests that match the rule match statement. See `rule_label` below for details.
 * @property statement The AWS WAF processing statement for the rule, for example `byte_match_statement` or `geo_match_statement`. See `statement` below for details.
 * @property visibilityConfig Defines and enables Amazon CloudWatch metrics and web request sample collection. See `visibility_config` below for details.
 */
public data class WebAclRule(
    public val action: WebAclRuleAction? = null,
    public val captchaConfig: WebAclRuleCaptchaConfig? = null,
    public val name: String,
    public val overrideAction: WebAclRuleOverrideAction? = null,
    public val priority: Int,
    public val ruleLabels: List<WebAclRuleRuleLabel>? = null,
    public val statement: WebAclRuleStatement,
    public val visibilityConfig: WebAclRuleVisibilityConfig,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.WebAclRule): WebAclRule = WebAclRule(
            action = javaType.action().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleAction.Companion.toKotlin(args0)
                })
            }).orElse(null),
            captchaConfig = javaType.captchaConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleCaptchaConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            overrideAction = javaType.overrideAction().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleOverrideAction.Companion.toKotlin(args0)
                })
            }).orElse(null),
            priority = javaType.priority(),
            ruleLabels = javaType.ruleLabels().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleRuleLabel.Companion.toKotlin(args0)
                })
            }),
            statement = javaType.statement().let({ args0 ->
                com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatement.Companion.toKotlin(args0)
            }),
            visibilityConfig = javaType.visibilityConfig().let({ args0 ->
                com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleVisibilityConfig.Companion.toKotlin(args0)
            }),
        )
    }
}
