@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property name Name of the custom header. For custom request header insertion, when AWS WAF inserts the header into the request, it prefixes this name `x-amzn-waf-`, to avoid confusion with the headers that are already in the request. For example, for the header name `sample`, AWS WAF inserts the header `x-amzn-waf-sample`.
 * @property value Value of the custom header.
 */
public data class WebAclRuleActionChallengeCustomRequestHandlingInsertHeader(
    public val name: String,
    public val `value`: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.WebAclRuleActionChallengeCustomRequestHandlingInsertHeader):
            WebAclRuleActionChallengeCustomRequestHandlingInsertHeader =
            WebAclRuleActionChallengeCustomRequestHandlingInsertHeader(
                name = javaType.name(),
                `value` = javaType.`value`(),
            )
    }
}
