@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property andStatement Logical rule statement used to combine other rule statements with AND logic. See `and_statement` below for details.
 * @property byteMatchStatement Rule statement that defines a string match search for AWS WAF to apply to web requests. See `byte_match_statement` below for details.
 * @property geoMatchStatement Rule statement used to identify web requests based on country of origin. See `geo_match_statement` below for details.
 * @property ipSetReferenceStatement Rule statement used to detect web requests coming from particular IP addresses or address ranges. See `ip_set_reference_statement` below for details.
 * @property labelMatchStatement Rule statement that defines a string match search against labels that have been added to the web request by rules that have already run in the web ACL. See `label_match_statement` below for details.
 * @property managedRuleGroupStatement Rule statement used to run the rules that are defined in a managed rule group.  This statement can not be nested. See `managed_rule_group_statement` below for details.
 * @property notStatement Logical rule statement used to negate the results of another rule statement. See `not_statement` below for details.
 * @property orStatement Logical rule statement used to combine other rule statements with OR logic. See `or_statement` below for details.
 * @property rateBasedStatement Rate-based rule tracks the rate of requests for each originating `IP address`, and triggers the rule action when the rate exceeds a limit that you specify on the number of requests in any `5-minute` time span. This statement can not be nested. See `rate_based_statement` below for details.
 * @property regexMatchStatement Rule statement used to search web request components for a match against a single regular expression. See `regex_match_statement` below for details.
 * @property regexPatternSetReferenceStatement Rule statement used to search web request components for matches with regular expressions. See `regex_pattern_set_reference_statement` below for details.
 * @property ruleGroupReferenceStatement Rule statement used to run the rules that are defined in an WAFv2 Rule Group. See `rule_group_reference_statement` below for details.
 * @property sizeConstraintStatement Rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<). See `size_constraint_statement` below for more details.
 * @property sqliMatchStatement An SQL injection match condition identifies the part of web requests, such as the URI or the query string, that you want AWS WAF to inspect. See `sqli_match_statement` below for details.
 * @property xssMatchStatement Rule statement that defines a cross-site scripting (XSS) match search for AWS WAF to apply to web requests. See `xss_match_statement` below for details.
 */
public data class WebAclRuleStatement(
    public val andStatement: WebAclRuleStatementAndStatement? = null,
    public val byteMatchStatement: WebAclRuleStatementByteMatchStatement? = null,
    public val geoMatchStatement: WebAclRuleStatementGeoMatchStatement? = null,
    public val ipSetReferenceStatement: WebAclRuleStatementIpSetReferenceStatement? = null,
    public val labelMatchStatement: WebAclRuleStatementLabelMatchStatement? = null,
    public val managedRuleGroupStatement: WebAclRuleStatementManagedRuleGroupStatement? = null,
    public val notStatement: WebAclRuleStatementNotStatement? = null,
    public val orStatement: WebAclRuleStatementOrStatement? = null,
    public val rateBasedStatement: WebAclRuleStatementRateBasedStatement? = null,
    public val regexMatchStatement: WebAclRuleStatementRegexMatchStatement? = null,
    public val regexPatternSetReferenceStatement:
    WebAclRuleStatementRegexPatternSetReferenceStatement? = null,
    public val ruleGroupReferenceStatement: WebAclRuleStatementRuleGroupReferenceStatement? = null,
    public val sizeConstraintStatement: WebAclRuleStatementSizeConstraintStatement? = null,
    public val sqliMatchStatement: WebAclRuleStatementSqliMatchStatement? = null,
    public val xssMatchStatement: WebAclRuleStatementXssMatchStatement? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.WebAclRuleStatement):
            WebAclRuleStatement = WebAclRuleStatement(
            andStatement = javaType.andStatement().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementAndStatement.Companion.toKotlin(args0)
                })
            }).orElse(null),
            byteMatchStatement = javaType.byteMatchStatement().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementByteMatchStatement.Companion.toKotlin(args0)
                })
            }).orElse(null),
            geoMatchStatement = javaType.geoMatchStatement().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementGeoMatchStatement.Companion.toKotlin(args0)
                })
            }).orElse(null),
            ipSetReferenceStatement = javaType.ipSetReferenceStatement().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementIpSetReferenceStatement.Companion.toKotlin(args0)
                })
            }).orElse(null),
            labelMatchStatement = javaType.labelMatchStatement().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementLabelMatchStatement.Companion.toKotlin(args0)
                })
            }).orElse(null),
            managedRuleGroupStatement = javaType.managedRuleGroupStatement().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementManagedRuleGroupStatement.Companion.toKotlin(args0)
                })
            }).orElse(null),
            notStatement = javaType.notStatement().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementNotStatement.Companion.toKotlin(args0)
                })
            }).orElse(null),
            orStatement = javaType.orStatement().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementOrStatement.Companion.toKotlin(args0)
                })
            }).orElse(null),
            rateBasedStatement = javaType.rateBasedStatement().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRateBasedStatement.Companion.toKotlin(args0)
                })
            }).orElse(null),
            regexMatchStatement = javaType.regexMatchStatement().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRegexMatchStatement.Companion.toKotlin(args0)
                })
            }).orElse(null),
            regexPatternSetReferenceStatement = javaType.regexPatternSetReferenceStatement().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRegexPatternSetReferenceStatement.Companion.toKotlin(args0)
                })
            }).orElse(null),
            ruleGroupReferenceStatement = javaType.ruleGroupReferenceStatement().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRuleGroupReferenceStatement.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sizeConstraintStatement = javaType.sizeConstraintStatement().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementSizeConstraintStatement.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sqliMatchStatement = javaType.sqliMatchStatement().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementSqliMatchStatement.Companion.toKotlin(args0)
                })
            }).orElse(null),
            xssMatchStatement = javaType.xssMatchStatement().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementXssMatchStatement.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
