@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property arn The Amazon Resource Name (ARN) of the IP Set that this statement references.
 * @property ipSetForwardedIpConfig Configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. See `ip_set_forwarded_ip_config` below for more details.
 */
public data class WebAclRuleStatementIpSetReferenceStatement(
    public val arn: String,
    public val ipSetForwardedIpConfig:
    WebAclRuleStatementIpSetReferenceStatementIpSetForwardedIpConfig? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.WebAclRuleStatementIpSetReferenceStatement):
            WebAclRuleStatementIpSetReferenceStatement = WebAclRuleStatementIpSetReferenceStatement(
            arn = javaType.arn(),
            ipSetForwardedIpConfig = javaType.ipSetForwardedIpConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementIpSetReferenceStatementIpSetForwardedIpConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
