@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property fallbackBehavior Match status to assign to the web request if the request doesn't have a valid IP address in the specified position. Valid values include: `MATCH` or `NO_MATCH`.
 * @property headerName Name of the HTTP header to use for the IP address.
 * @property position Position in the header to search for the IP address. Valid values include: `FIRST`, `LAST`, or `ANY`. If `ANY` is specified and the header contains more than 10 IP addresses, AWS WAFv2 inspects the last 10.
 */
public data class WebAclRuleStatementIpSetReferenceStatementIpSetForwardedIpConfig(
    public val fallbackBehavior: String,
    public val headerName: String,
    public val position: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.WebAclRuleStatementIpSetReferenceStatementIpSetForwardedIpConfig):
            WebAclRuleStatementIpSetReferenceStatementIpSetForwardedIpConfig =
            WebAclRuleStatementIpSetReferenceStatementIpSetForwardedIpConfig(
                fallbackBehavior = javaType.fallbackBehavior(),
                headerName = javaType.headerName(),
                position = javaType.position(),
            )
    }
}
