@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property managedRuleGroupConfigs Additional information that's used by a managed rule group. Only one rule attribute is allowed in each config. See `managed_rule_group_configs` for more details
 * @property name Name of the managed rule group.
 * @property ruleActionOverrides Action settings to use in the place of the rule actions that are configured inside the rule group. You specify one override for each rule whose action you want to change. See `rule_action_override` below for details.
 * @property scopeDownStatement Narrows the scope of the statement to matching web requests. This can be any nestable statement, and you can nest statements at any level below this scope-down statement. See `statement` above for details.
 * @property vendorName Name of the managed rule group vendor.
 * @property version Version of the managed rule group. You can set `Version_1.0` or `Version_1.1` etc. If you want to use the default version, do not set anything.
 */
public data class WebAclRuleStatementManagedRuleGroupStatement(
    public val managedRuleGroupConfigs:
    List<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfig>? = null,
    public val name: String,
    public val ruleActionOverrides:
    List<WebAclRuleStatementManagedRuleGroupStatementRuleActionOverride>? = null,
    public val scopeDownStatement: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatement? =
        null,
    public val vendorName: String,
    public val version: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.WebAclRuleStatementManagedRuleGroupStatement):
            WebAclRuleStatementManagedRuleGroupStatement = WebAclRuleStatementManagedRuleGroupStatement(
            managedRuleGroupConfigs = javaType.managedRuleGroupConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfig.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            ruleActionOverrides = javaType.ruleActionOverrides().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementManagedRuleGroupStatementRuleActionOverride.Companion.toKotlin(args0)
                })
            }),
            scopeDownStatement = javaType.scopeDownStatement().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatement.Companion.toKotlin(args0)
                })
            }).orElse(null),
            vendorName = javaType.vendorName(),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
