@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enableRegexInPath Whether or not to allow the use of regular expressions in the login page path.
 * @property loginPath The path of the login endpoint for your application.
 * @property requestInspection The criteria for inspecting login requests, used by the ATP rule group to validate credentials usage. See `request_inspection` for more details.
 * @property responseInspection The criteria for inspecting responses to login requests, used by the ATP rule group to track login failure rates. Note that Response Inspection is available only on web ACLs that protect CloudFront distributions. See `response_inspection` for more details.
 */
public data class
WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSet(
    public val enableRegexInPath: Boolean? = null,
    public val loginPath: String,
    public val requestInspection:
    WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetRequestInspection? =
        null,
    public val responseInspection:
    WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetResponseInspection? =
        null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSet):
            WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSet =
            WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSet(
                enableRegexInPath = javaType.enableRegexInPath().map({ args0 -> args0 }).orElse(null),
                loginPath = javaType.loginPath(),
                requestInspection = javaType.requestInspection().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetRequestInspection.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                responseInspection = javaType.responseInspection().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetResponseInspection.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
