@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property aggregateKeyType Setting that indicates how to aggregate the request counts. Valid values include: `CONSTANT`, `CUSTOM_KEYS`, `FORWARDED_IP`, or `IP`. Default: `IP`.
 * @property customKeys Aggregate the request counts using one or more web request components as the aggregate keys. See `custom_key` below for details.
 * @property forwardedIpConfig Configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. If `aggregate_key_type` is set to `FORWARDED_IP`, this block is required. See `forwarded_ip_config` below for details.
 * @property limit Limit on requests per 5-minute period for a single originating IP address.
 * @property scopeDownStatement Optional nested statement that narrows the scope of the rate-based statement to matching web requests. This can be any nestable statement, and you can nest statements at any level below this scope-down statement. See `statement` above for details. If `aggregate_key_type` is set to `CONSTANT`, this block is required.
 */
public data class WebAclRuleStatementRateBasedStatement(
    public val aggregateKeyType: String? = null,
    public val customKeys: List<WebAclRuleStatementRateBasedStatementCustomKey>? = null,
    public val forwardedIpConfig: WebAclRuleStatementRateBasedStatementForwardedIpConfig? = null,
    public val limit: Int,
    public val scopeDownStatement: WebAclRuleStatementRateBasedStatementScopeDownStatement? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.WebAclRuleStatementRateBasedStatement):
            WebAclRuleStatementRateBasedStatement = WebAclRuleStatementRateBasedStatement(
            aggregateKeyType = javaType.aggregateKeyType().map({ args0 -> args0 }).orElse(null),
            customKeys = javaType.customKeys().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRateBasedStatementCustomKey.Companion.toKotlin(args0)
                })
            }),
            forwardedIpConfig = javaType.forwardedIpConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRateBasedStatementForwardedIpConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            limit = javaType.limit(),
            scopeDownStatement = javaType.scopeDownStatement().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRateBasedStatementScopeDownStatement.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
