@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property oversizeHandling What WAF should do if the body is larger than WAF can inspect. WAF does not support inspecting the entire contents of the body of a web request when the body exceeds 8 KB (8192 bytes). Only the first 8 KB of the request body are forwarded to WAF by the underlying host service. Valid values: `CONTINUE`, `MATCH`, `NO_MATCH`.
 */
public data class
WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchBody(
    public val oversizeHandling: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchBody):
            WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchBody =
            WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchBody(
                oversizeHandling = javaType.oversizeHandling().map({ args0 -> args0 }).orElse(null),
            )
    }
}
