@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property fieldToMatch The part of a web request that you want AWS WAF to inspect. See `field_to_match` below for details.
 * @property regexString String representing the regular expression. Minimum of `1` and maximum of `512` characters.
 * @property textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
 */
public data class WebAclRuleStatementRegexMatchStatement(
    public val fieldToMatch: WebAclRuleStatementRegexMatchStatementFieldToMatch? = null,
    public val regexString: String,
    public val textTransformations: List<WebAclRuleStatementRegexMatchStatementTextTransformation>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.WebAclRuleStatementRegexMatchStatement):
            WebAclRuleStatementRegexMatchStatement = WebAclRuleStatementRegexMatchStatement(
            fieldToMatch = javaType.fieldToMatch().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRegexMatchStatementFieldToMatch.Companion.toKotlin(args0)
                })
            }).orElse(null),
            regexString = javaType.regexString(),
            textTransformations = javaType.textTransformations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRegexMatchStatementTextTransformation.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
