@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property comparisonOperator Operator to use to compare the request part to the size setting. Valid values include: `EQ`, `NE`, `LE`, `LT`, `GE`, or `GT`.
 * @property fieldToMatch Part of a web request that you want AWS WAF to inspect. See `field_to_match` below for details.
 * @property size Size, in bytes, to compare to the request part, after any transformations. Valid values are integers between 0 and 21474836480, inclusive.
 * @property textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
 */
public data class WebAclRuleStatementSizeConstraintStatement(
    public val comparisonOperator: String,
    public val fieldToMatch: WebAclRuleStatementSizeConstraintStatementFieldToMatch? = null,
    public val size: Int,
    public val textTransformations:
    List<WebAclRuleStatementSizeConstraintStatementTextTransformation>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.WebAclRuleStatementSizeConstraintStatement):
            WebAclRuleStatementSizeConstraintStatement = WebAclRuleStatementSizeConstraintStatement(
            comparisonOperator = javaType.comparisonOperator(),
            fieldToMatch = javaType.fieldToMatch().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementSizeConstraintStatementFieldToMatch.Companion.toKotlin(args0)
                })
            }).orElse(null),
            size = javaType.size(),
            textTransformations = javaType.textTransformations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementSizeConstraintStatementTextTransformation.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
