@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property allQueryArguments Inspect all query arguments.
 * @property body Inspect the request body, which immediately follows the request headers. See `body` below for details.
 * @property cookies Inspect the cookies in the web request. See `cookies` below for details.
 * @property headers Inspect the request headers. See `headers` below for details.
 * @property ja3Fingerprint Inspect the JA3 fingerprint. See `ja3_fingerprint` below for details.
 * @property jsonBody Inspect the request body as JSON. See `json_body` for details.
 * @property method Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
 * @property queryString Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
 * @property singleHeader Inspect a single header. See `single_header` below for details.
 * @property singleQueryArgument Inspect a single query argument. See `single_query_argument` below for details.
 * @property uriPath Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
 */
public data class WebAclRuleStatementSizeConstraintStatementFieldToMatch(
    public val allQueryArguments:
    WebAclRuleStatementSizeConstraintStatementFieldToMatchAllQueryArguments? = null,
    public val body: WebAclRuleStatementSizeConstraintStatementFieldToMatchBody? = null,
    public val cookies: WebAclRuleStatementSizeConstraintStatementFieldToMatchCookies? = null,
    public val headers: List<WebAclRuleStatementSizeConstraintStatementFieldToMatchHeader>? = null,
    public val ja3Fingerprint: WebAclRuleStatementSizeConstraintStatementFieldToMatchJa3Fingerprint? =
        null,
    public val jsonBody: WebAclRuleStatementSizeConstraintStatementFieldToMatchJsonBody? = null,
    public val method: WebAclRuleStatementSizeConstraintStatementFieldToMatchMethod? = null,
    public val queryString: WebAclRuleStatementSizeConstraintStatementFieldToMatchQueryString? = null,
    public val singleHeader: WebAclRuleStatementSizeConstraintStatementFieldToMatchSingleHeader? =
        null,
    public val singleQueryArgument:
    WebAclRuleStatementSizeConstraintStatementFieldToMatchSingleQueryArgument? = null,
    public val uriPath: WebAclRuleStatementSizeConstraintStatementFieldToMatchUriPath? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.WebAclRuleStatementSizeConstraintStatementFieldToMatch):
            WebAclRuleStatementSizeConstraintStatementFieldToMatch =
            WebAclRuleStatementSizeConstraintStatementFieldToMatch(
                allQueryArguments = javaType.allQueryArguments().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementSizeConstraintStatementFieldToMatchAllQueryArguments.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                body = javaType.body().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementSizeConstraintStatementFieldToMatchBody.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                cookies = javaType.cookies().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementSizeConstraintStatementFieldToMatchCookies.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                headers = javaType.headers().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementSizeConstraintStatementFieldToMatchHeader.Companion.toKotlin(args0)
                    })
                }),
                ja3Fingerprint = javaType.ja3Fingerprint().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementSizeConstraintStatementFieldToMatchJa3Fingerprint.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                jsonBody = javaType.jsonBody().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementSizeConstraintStatementFieldToMatchJsonBody.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                method = javaType.method().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementSizeConstraintStatementFieldToMatchMethod.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                queryString = javaType.queryString().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementSizeConstraintStatementFieldToMatchQueryString.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                singleHeader = javaType.singleHeader().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementSizeConstraintStatementFieldToMatchSingleHeader.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                singleQueryArgument = javaType.singleQueryArgument().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementSizeConstraintStatementFieldToMatchSingleQueryArgument.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                uriPath = javaType.uriPath().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementSizeConstraintStatementFieldToMatchUriPath.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
