@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property fieldToMatch Part of a web request that you want AWS WAF to inspect. See `field_to_match` below for details.
 * @property textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
 */
public data class WebAclRuleStatementXssMatchStatement(
    public val fieldToMatch: WebAclRuleStatementXssMatchStatementFieldToMatch? = null,
    public val textTransformations: List<WebAclRuleStatementXssMatchStatementTextTransformation>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.WebAclRuleStatementXssMatchStatement):
            WebAclRuleStatementXssMatchStatement = WebAclRuleStatementXssMatchStatement(
            fieldToMatch = javaType.fieldToMatch().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementXssMatchStatementFieldToMatch.Companion.toKotlin(args0)
                })
            }).orElse(null),
            textTransformations = javaType.textTransformations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementXssMatchStatementTextTransformation.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
