@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.worklink.kotlin

import com.pulumi.aws.worklink.kotlin.outputs.FleetIdentityProvider
import com.pulumi.aws.worklink.kotlin.outputs.FleetNetwork
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.worklink.kotlin.outputs.FleetIdentityProvider.Companion.toKotlin as fleetIdentityProviderToKotlin
import com.pulumi.aws.worklink.kotlin.outputs.FleetNetwork.Companion.toKotlin as fleetNetworkToKotlin

/**
 * Builder for [Fleet].
 */
@PulumiTagMarker
public class FleetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FleetArgs = FleetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FleetArgsBuilder.() -> Unit) {
        val builder = FleetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Fleet {
        val builtJavaResource = com.pulumi.aws.worklink.Fleet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Fleet(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * Basic usage:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.worklink.Fleet;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Fleet("example");
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import WorkLink using the ARN. For example:
 * ```sh
 *  $ pulumi import aws:worklink/fleet:Fleet test arn:aws:worklink::123456789012:fleet/example
 * ```
 *
 */
public class Fleet internal constructor(
    override val javaResource: com.pulumi.aws.worklink.Fleet,
) : KotlinCustomResource(javaResource, FleetMapper) {
    /**
     * The ARN of the created WorkLink Fleet.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The ARN of the Amazon Kinesis data stream that receives the audit events. Kinesis data stream name must begin with `"AmazonWorkLink-"`.
     */
    public val auditStreamArn: Output<String>?
        get() = javaResource.auditStreamArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The identifier used by users to sign in to the Amazon WorkLink app.
     */
    public val companyCode: Output<String>
        get() = javaResource.companyCode().applyValue({ args0 -> args0 })

    /**
     * The time that the fleet was created.
     */
    public val createdTime: Output<String>
        get() = javaResource.createdTime().applyValue({ args0 -> args0 })

    /**
     * The certificate chain, including intermediate certificates and the root certificate authority certificate used to issue device certificates.
     */
    public val deviceCaCertificate: Output<String>?
        get() = javaResource.deviceCaCertificate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the fleet.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Provide this to allow manage the identity provider configuration for the fleet. Fields documented below.
     */
    public val identityProvider: Output<FleetIdentityProvider>?
        get() = javaResource.identityProvider().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> fleetIdentityProviderToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The time that the fleet was last updated.
     */
    public val lastUpdatedTime: Output<String>
        get() = javaResource.lastUpdatedTime().applyValue({ args0 -> args0 })

    /**
     * A region-unique name for the AMI.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provide this to allow manage the company network configuration for the fleet. Fields documented below.
     */
    public val network: Output<FleetNetwork>?
        get() = javaResource.network().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    fleetNetworkToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The option to optimize for better performance by routing traffic through the closest AWS Region to users, which may be outside of your home Region. Defaults to `true`.
     * **network** requires the following:
     * > **NOTE:** `network` is cannot removed without force recreating.
     */
    public val optimizeForEndUserLocation: Output<Boolean>?
        get() = javaResource.optimizeForEndUserLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object FleetMapper : ResourceMapper<Fleet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.worklink.Fleet::class == javaResource::class

    override fun map(javaResource: Resource): Fleet = Fleet(
        javaResource as
            com.pulumi.aws.worklink.Fleet,
    )
}

/**
 * @see [Fleet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Fleet].
 */
public suspend fun fleet(name: String, block: suspend FleetResourceBuilder.() -> Unit): Fleet {
    val builder = FleetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Fleet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun fleet(name: String): Fleet {
    val builder = FleetResourceBuilder()
    builder.name(name)
    return builder.build()
}
