@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.worklink.kotlin

import com.pulumi.aws.worklink.FleetArgs.builder
import com.pulumi.aws.worklink.kotlin.inputs.FleetIdentityProviderArgs
import com.pulumi.aws.worklink.kotlin.inputs.FleetIdentityProviderArgsBuilder
import com.pulumi.aws.worklink.kotlin.inputs.FleetNetworkArgs
import com.pulumi.aws.worklink.kotlin.inputs.FleetNetworkArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * Basic usage:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.worklink.Fleet;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Fleet("example");
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import WorkLink using the ARN. For example:
 * ```sh
 *  $ pulumi import aws:worklink/fleet:Fleet test arn:aws:worklink::123456789012:fleet/example
 * ```
 * @property auditStreamArn The ARN of the Amazon Kinesis data stream that receives the audit events. Kinesis data stream name must begin with `"AmazonWorkLink-"`.
 * @property deviceCaCertificate The certificate chain, including intermediate certificates and the root certificate authority certificate used to issue device certificates.
 * @property displayName The name of the fleet.
 * @property identityProvider Provide this to allow manage the identity provider configuration for the fleet. Fields documented below.
 * @property name A region-unique name for the AMI.
 * @property network Provide this to allow manage the company network configuration for the fleet. Fields documented below.
 * @property optimizeForEndUserLocation The option to optimize for better performance by routing traffic through the closest AWS Region to users, which may be outside of your home Region. Defaults to `true`.
 * **network** requires the following:
 * > **NOTE:** `network` is cannot removed without force recreating.
 */
public data class FleetArgs(
    public val auditStreamArn: Output<String>? = null,
    public val deviceCaCertificate: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val identityProvider: Output<FleetIdentityProviderArgs>? = null,
    public val name: Output<String>? = null,
    public val network: Output<FleetNetworkArgs>? = null,
    public val optimizeForEndUserLocation: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.worklink.FleetArgs> {
    override fun toJava(): com.pulumi.aws.worklink.FleetArgs =
        com.pulumi.aws.worklink.FleetArgs.builder()
            .auditStreamArn(auditStreamArn?.applyValue({ args0 -> args0 }))
            .deviceCaCertificate(deviceCaCertificate?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .identityProvider(identityProvider?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .network(network?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .optimizeForEndUserLocation(optimizeForEndUserLocation?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FleetArgs].
 */
@PulumiTagMarker
public class FleetArgsBuilder internal constructor() {
    private var auditStreamArn: Output<String>? = null

    private var deviceCaCertificate: Output<String>? = null

    private var displayName: Output<String>? = null

    private var identityProvider: Output<FleetIdentityProviderArgs>? = null

    private var name: Output<String>? = null

    private var network: Output<FleetNetworkArgs>? = null

    private var optimizeForEndUserLocation: Output<Boolean>? = null

    /**
     * @param value The ARN of the Amazon Kinesis data stream that receives the audit events. Kinesis data stream name must begin with `"AmazonWorkLink-"`.
     */
    @JvmName("dssxjhpbjwbvgopf")
    public suspend fun auditStreamArn(`value`: Output<String>) {
        this.auditStreamArn = value
    }

    /**
     * @param value The certificate chain, including intermediate certificates and the root certificate authority certificate used to issue device certificates.
     */
    @JvmName("aokhfpnwxycmofxt")
    public suspend fun deviceCaCertificate(`value`: Output<String>) {
        this.deviceCaCertificate = value
    }

    /**
     * @param value The name of the fleet.
     */
    @JvmName("usuifwciayosbgew")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Provide this to allow manage the identity provider configuration for the fleet. Fields documented below.
     */
    @JvmName("qhqdqkjowtkauwmt")
    public suspend fun identityProvider(`value`: Output<FleetIdentityProviderArgs>) {
        this.identityProvider = value
    }

    /**
     * @param value A region-unique name for the AMI.
     */
    @JvmName("xbfetdgetsfjbdys")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Provide this to allow manage the company network configuration for the fleet. Fields documented below.
     */
    @JvmName("lliygufhwdbmmorp")
    public suspend fun network(`value`: Output<FleetNetworkArgs>) {
        this.network = value
    }

    /**
     * @param value The option to optimize for better performance by routing traffic through the closest AWS Region to users, which may be outside of your home Region. Defaults to `true`.
     * **network** requires the following:
     * > **NOTE:** `network` is cannot removed without force recreating.
     */
    @JvmName("jcqpyeignudpkqar")
    public suspend fun optimizeForEndUserLocation(`value`: Output<Boolean>) {
        this.optimizeForEndUserLocation = value
    }

    /**
     * @param value The ARN of the Amazon Kinesis data stream that receives the audit events. Kinesis data stream name must begin with `"AmazonWorkLink-"`.
     */
    @JvmName("dqoyjihbfelvsuxp")
    public suspend fun auditStreamArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auditStreamArn = mapped
    }

    /**
     * @param value The certificate chain, including intermediate certificates and the root certificate authority certificate used to issue device certificates.
     */
    @JvmName("tffcaskpodouqoom")
    public suspend fun deviceCaCertificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceCaCertificate = mapped
    }

    /**
     * @param value The name of the fleet.
     */
    @JvmName("iavvqghaecdfrbvp")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Provide this to allow manage the identity provider configuration for the fleet. Fields documented below.
     */
    @JvmName("ridhkynrlbgurkvf")
    public suspend fun identityProvider(`value`: FleetIdentityProviderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityProvider = mapped
    }

    /**
     * @param argument Provide this to allow manage the identity provider configuration for the fleet. Fields documented below.
     */
    @JvmName("mwmyhtseerrstvvw")
    public suspend
    fun identityProvider(argument: suspend FleetIdentityProviderArgsBuilder.() -> Unit) {
        val toBeMapped = FleetIdentityProviderArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identityProvider = mapped
    }

    /**
     * @param value A region-unique name for the AMI.
     */
    @JvmName("neornrmdgpenpimp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Provide this to allow manage the company network configuration for the fleet. Fields documented below.
     */
    @JvmName("ukhqgejchyxjhgvu")
    public suspend fun network(`value`: FleetNetworkArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.network = mapped
    }

    /**
     * @param argument Provide this to allow manage the company network configuration for the fleet. Fields documented below.
     */
    @JvmName("uvbgpxjlmvwseeka")
    public suspend fun network(argument: suspend FleetNetworkArgsBuilder.() -> Unit) {
        val toBeMapped = FleetNetworkArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.network = mapped
    }

    /**
     * @param value The option to optimize for better performance by routing traffic through the closest AWS Region to users, which may be outside of your home Region. Defaults to `true`.
     * **network** requires the following:
     * > **NOTE:** `network` is cannot removed without force recreating.
     */
    @JvmName("umtbvotqgrgncnda")
    public suspend fun optimizeForEndUserLocation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.optimizeForEndUserLocation = mapped
    }

    internal fun build(): FleetArgs = FleetArgs(
        auditStreamArn = auditStreamArn,
        deviceCaCertificate = deviceCaCertificate,
        displayName = displayName,
        identityProvider = identityProvider,
        name = name,
        network = network,
        optimizeForEndUserLocation = optimizeForEndUserLocation,
    )
}
