@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.worklink.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WebsiteCertificateAuthorityAssociation].
 */
@PulumiTagMarker
public class WebsiteCertificateAuthorityAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebsiteCertificateAuthorityAssociationArgs =
        WebsiteCertificateAuthorityAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend WebsiteCertificateAuthorityAssociationArgsBuilder.() -> Unit) {
        val builder = WebsiteCertificateAuthorityAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): WebsiteCertificateAuthorityAssociation {
        val builtJavaResource =
            com.pulumi.aws.worklink.WebsiteCertificateAuthorityAssociation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WebsiteCertificateAuthorityAssociation(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.worklink.Fleet;
 * import com.pulumi.aws.worklink.WebsiteCertificateAuthorityAssociation;
 * import com.pulumi.aws.worklink.WebsiteCertificateAuthorityAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Fleet("example");
 *         var test = new WebsiteCertificateAuthorityAssociation("test", WebsiteCertificateAuthorityAssociationArgs.builder()
 *             .fleetArn(aws_worklink_fleet.test().arn())
 *             .certificate(Files.readString(Paths.get("certificate.pem")))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import WorkLink Website Certificate Authority using `FLEET-ARN,WEBSITE-CA-ID`. For example:
 * ```sh
 *  $ pulumi import aws:worklink/websiteCertificateAuthorityAssociation:WebsiteCertificateAuthorityAssociation example arn:aws:worklink::123456789012:fleet/example,abcdefghijk
 * ```
 *
 */
public class WebsiteCertificateAuthorityAssociation internal constructor(
    override val javaResource: com.pulumi.aws.worklink.WebsiteCertificateAuthorityAssociation,
) : KotlinCustomResource(javaResource, WebsiteCertificateAuthorityAssociationMapper) {
    /**
     * The root certificate of the Certificate Authority.
     */
    public val certificate: Output<String>
        get() = javaResource.certificate().applyValue({ args0 -> args0 })

    /**
     * The certificate name to display.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARN of the fleet.
     */
    public val fleetArn: Output<String>
        get() = javaResource.fleetArn().applyValue({ args0 -> args0 })

    /**
     * A unique identifier for the Certificate Authority.
     */
    public val websiteCaId: Output<String>
        get() = javaResource.websiteCaId().applyValue({ args0 -> args0 })
}

public object WebsiteCertificateAuthorityAssociationMapper :
    ResourceMapper<WebsiteCertificateAuthorityAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.worklink.WebsiteCertificateAuthorityAssociation::class == javaResource::class

    override fun map(javaResource: Resource): WebsiteCertificateAuthorityAssociation =
        WebsiteCertificateAuthorityAssociation(
            javaResource as
                com.pulumi.aws.worklink.WebsiteCertificateAuthorityAssociation,
        )
}

/**
 * @see [WebsiteCertificateAuthorityAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebsiteCertificateAuthorityAssociation].
 */
public suspend fun websiteCertificateAuthorityAssociation(
    name: String,
    block: suspend WebsiteCertificateAuthorityAssociationResourceBuilder.() -> Unit,
):
    WebsiteCertificateAuthorityAssociation {
    val builder = WebsiteCertificateAuthorityAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebsiteCertificateAuthorityAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun websiteCertificateAuthorityAssociation(name: String):
    WebsiteCertificateAuthorityAssociation {
    val builder = WebsiteCertificateAuthorityAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
