@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.worklink.kotlin

import com.pulumi.aws.worklink.WebsiteCertificateAuthorityAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.worklink.Fleet;
 * import com.pulumi.aws.worklink.WebsiteCertificateAuthorityAssociation;
 * import com.pulumi.aws.worklink.WebsiteCertificateAuthorityAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Fleet("example");
 *         var test = new WebsiteCertificateAuthorityAssociation("test", WebsiteCertificateAuthorityAssociationArgs.builder()
 *             .fleetArn(aws_worklink_fleet.test().arn())
 *             .certificate(Files.readString(Paths.get("certificate.pem")))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import WorkLink Website Certificate Authority using `FLEET-ARN,WEBSITE-CA-ID`. For example:
 * ```sh
 *  $ pulumi import aws:worklink/websiteCertificateAuthorityAssociation:WebsiteCertificateAuthorityAssociation example arn:aws:worklink::123456789012:fleet/example,abcdefghijk
 * ```
 * @property certificate The root certificate of the Certificate Authority.
 * @property displayName The certificate name to display.
 * @property fleetArn The ARN of the fleet.
 */
public data class WebsiteCertificateAuthorityAssociationArgs(
    public val certificate: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val fleetArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.worklink.WebsiteCertificateAuthorityAssociationArgs> {
    override fun toJava(): com.pulumi.aws.worklink.WebsiteCertificateAuthorityAssociationArgs =
        com.pulumi.aws.worklink.WebsiteCertificateAuthorityAssociationArgs.builder()
            .certificate(certificate?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .fleetArn(fleetArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebsiteCertificateAuthorityAssociationArgs].
 */
@PulumiTagMarker
public class WebsiteCertificateAuthorityAssociationArgsBuilder internal constructor() {
    private var certificate: Output<String>? = null

    private var displayName: Output<String>? = null

    private var fleetArn: Output<String>? = null

    /**
     * @param value The root certificate of the Certificate Authority.
     */
    @JvmName("bwnjjyxbnqlclyjy")
    public suspend fun certificate(`value`: Output<String>) {
        this.certificate = value
    }

    /**
     * @param value The certificate name to display.
     */
    @JvmName("ovisymgbypewrwxu")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The ARN of the fleet.
     */
    @JvmName("hwogoipsdmdyupqk")
    public suspend fun fleetArn(`value`: Output<String>) {
        this.fleetArn = value
    }

    /**
     * @param value The root certificate of the Certificate Authority.
     */
    @JvmName("slalkthdmttrihrj")
    public suspend fun certificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificate = mapped
    }

    /**
     * @param value The certificate name to display.
     */
    @JvmName("beuklqhtsnainjsk")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The ARN of the fleet.
     */
    @JvmName("pojbkrfuwjpfsnir")
    public suspend fun fleetArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fleetArn = mapped
    }

    internal fun build(): WebsiteCertificateAuthorityAssociationArgs =
        WebsiteCertificateAuthorityAssociationArgs(
            certificate = certificate,
            displayName = displayName,
            fleetArn = fleetArn,
        )
}
