@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.worklink.kotlin.inputs

import com.pulumi.aws.worklink.inputs.FleetIdentityProviderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property samlMetadata The SAML metadata document provided by the customer’s identity provider.
 * @property type The type of identity provider.
 */
public data class FleetIdentityProviderArgs(
    public val samlMetadata: Output<String>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.worklink.inputs.FleetIdentityProviderArgs> {
    override fun toJava(): com.pulumi.aws.worklink.inputs.FleetIdentityProviderArgs =
        com.pulumi.aws.worklink.inputs.FleetIdentityProviderArgs.builder()
            .samlMetadata(samlMetadata.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FleetIdentityProviderArgs].
 */
@PulumiTagMarker
public class FleetIdentityProviderArgsBuilder internal constructor() {
    private var samlMetadata: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The SAML metadata document provided by the customer’s identity provider.
     */
    @JvmName("kfnxvkuafphiweyo")
    public suspend fun samlMetadata(`value`: Output<String>) {
        this.samlMetadata = value
    }

    /**
     * @param value The type of identity provider.
     */
    @JvmName("ltxpipshntapncgq")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The SAML metadata document provided by the customer’s identity provider.
     */
    @JvmName("mnfitacdqyioeeas")
    public suspend fun samlMetadata(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.samlMetadata = mapped
    }

    /**
     * @param value The type of identity provider.
     */
    @JvmName("krsuvehwjcopxgvv")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): FleetIdentityProviderArgs = FleetIdentityProviderArgs(
        samlMetadata = samlMetadata ?: throw PulumiNullFieldException("samlMetadata"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
