@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.workspaces.kotlin

import com.pulumi.aws.workspaces.kotlin.outputs.ConnectionAliasTimeouts
import com.pulumi.aws.workspaces.kotlin.outputs.ConnectionAliasTimeouts.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ConnectionAlias].
 */
@PulumiTagMarker
public class ConnectionAliasResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConnectionAliasArgs = ConnectionAliasArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConnectionAliasArgsBuilder.() -> Unit) {
        val builder = ConnectionAliasArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ConnectionAlias {
        val builtJavaResource = com.pulumi.aws.workspaces.ConnectionAlias(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ConnectionAlias(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS WorkSpaces Connection Alias.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.workspaces.ConnectionAlias;
 * import com.pulumi.aws.workspaces.ConnectionAliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ConnectionAlias("example", ConnectionAliasArgs.builder()
 *             .connectionString("testdomain.test")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import WorkSpaces Connection Alias using the connection alias ID. For example:
 * ```sh
 *  $ pulumi import aws:workspaces/connectionAlias:ConnectionAlias example rft-8012925589
 * ```
 *
 */
public class ConnectionAlias internal constructor(
    override val javaResource: com.pulumi.aws.workspaces.ConnectionAlias,
) : KotlinCustomResource(javaResource, ConnectionAliasMapper) {
    /**
     * The connection string specified for the connection alias. The connection string must be in the form of a fully qualified domain name (FQDN), such as www.example.com.
     */
    public val connectionString: Output<String>
        get() = javaResource.connectionString().applyValue({ args0 -> args0 })

    /**
     * The identifier of the Amazon Web Services account that owns the connection alias.
     */
    public val ownerAccountId: Output<String>
        get() = javaResource.ownerAccountId().applyValue({ args0 -> args0 })

    /**
     * The current state of the connection alias.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * A map of tags assigned to the WorkSpaces Connection Alias. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val timeouts: Output<ConnectionAliasTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })
}

public object ConnectionAliasMapper : ResourceMapper<ConnectionAlias> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.workspaces.ConnectionAlias::class == javaResource::class

    override fun map(javaResource: Resource): ConnectionAlias = ConnectionAlias(
        javaResource as
            com.pulumi.aws.workspaces.ConnectionAlias,
    )
}

/**
 * @see [ConnectionAlias].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConnectionAlias].
 */
public suspend fun connectionAlias(
    name: String,
    block: suspend ConnectionAliasResourceBuilder.() -> Unit,
): ConnectionAlias {
    val builder = ConnectionAliasResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConnectionAlias].
 * @param name The _unique_ name of the resulting resource.
 */
public fun connectionAlias(name: String): ConnectionAlias {
    val builder = ConnectionAliasResourceBuilder()
    builder.name(name)
    return builder.build()
}
