@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.workspaces.kotlin

import com.pulumi.aws.workspaces.kotlin.outputs.DirectorySelfServicePermissions
import com.pulumi.aws.workspaces.kotlin.outputs.DirectoryWorkspaceAccessProperties
import com.pulumi.aws.workspaces.kotlin.outputs.DirectoryWorkspaceCreationProperties
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.workspaces.kotlin.outputs.DirectorySelfServicePermissions.Companion.toKotlin as directorySelfServicePermissionsToKotlin
import com.pulumi.aws.workspaces.kotlin.outputs.DirectoryWorkspaceAccessProperties.Companion.toKotlin as directoryWorkspaceAccessPropertiesToKotlin
import com.pulumi.aws.workspaces.kotlin.outputs.DirectoryWorkspaceCreationProperties.Companion.toKotlin as directoryWorkspaceCreationPropertiesToKotlin

/**
 * Builder for [Directory].
 */
@PulumiTagMarker
public class DirectoryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DirectoryArgs = DirectoryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DirectoryArgsBuilder.() -> Unit) {
        val builder = DirectoryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Directory {
        val builtJavaResource = com.pulumi.aws.workspaces.Directory(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Directory(builtJavaResource)
    }
}

/**
 * Provides a WorkSpaces directory in AWS WorkSpaces Service.
 * > **NOTE:** AWS WorkSpaces service requires [`workspaces_DefaultRole`](https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role) IAM role to operate normally.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import com.pulumi.aws.workspaces.Directory;
 * import com.pulumi.aws.workspaces.DirectoryArgs;
 * import com.pulumi.aws.workspaces.inputs.DirectorySelfServicePermissionsArgs;
 * import com.pulumi.aws.workspaces.inputs.DirectoryWorkspaceAccessPropertiesArgs;
 * import com.pulumi.aws.workspaces.inputs.DirectoryWorkspaceCreationPropertiesArgs;
 * import com.pulumi.aws.directoryservice.Directory;
 * import com.pulumi.aws.directoryservice.DirectoryArgs;
 * import com.pulumi.aws.directoryservice.inputs.DirectoryVpcSettingsArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var workspaces = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("workspaces.amazonaws.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         var workspacesDefault = new Role("workspacesDefault", RoleArgs.builder()
 *             .assumeRolePolicy(workspaces.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var workspacesDefaultServiceAccess = new RolePolicyAttachment("workspacesDefaultServiceAccess", RolePolicyAttachmentArgs.builder()
 *             .role(workspacesDefault.name())
 *             .policyArn("arn:aws:iam::aws:policy/AmazonWorkSpacesServiceAccess")
 *             .build());
 *         var workspacesDefaultSelfServiceAccess = new RolePolicyAttachment("workspacesDefaultSelfServiceAccess", RolePolicyAttachmentArgs.builder()
 *             .role(workspacesDefault.name())
 *             .policyArn("arn:aws:iam::aws:policy/AmazonWorkSpacesSelfServiceAccess")
 *             .build());
 *         var exampleVpc = new Vpc("exampleVpc", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var exampleC = new Subnet("exampleC", SubnetArgs.builder()
 *             .vpcId(exampleVpc.id())
 *             .availabilityZone("us-east-1c")
 *             .cidrBlock("10.0.2.0/24")
 *             .build());
 *         var exampleD = new Subnet("exampleD", SubnetArgs.builder()
 *             .vpcId(exampleVpc.id())
 *             .availabilityZone("us-east-1d")
 *             .cidrBlock("10.0.3.0/24")
 *             .build());
 *         var exampleDirectory = new Directory("exampleDirectory", DirectoryArgs.builder()
 *             .directoryId(exampleDirectoryservice / directoryDirectory.id())
 *             .subnetIds(
 *                 exampleC.id(),
 *                 exampleD.id())
 *             .tags(Map.of("Example", true))
 *             .selfServicePermissions(DirectorySelfServicePermissionsArgs.builder()
 *                 .changeComputeType(true)
 *                 .increaseVolumeSize(true)
 *                 .rebuildWorkspace(true)
 *                 .restartWorkspace(true)
 *                 .switchRunningMode(true)
 *                 .build())
 *             .workspaceAccessProperties(DirectoryWorkspaceAccessPropertiesArgs.builder()
 *                 .deviceTypeAndroid("ALLOW")
 *                 .deviceTypeChromeos("ALLOW")
 *                 .deviceTypeIos("ALLOW")
 *                 .deviceTypeLinux("DENY")
 *                 .deviceTypeOsx("ALLOW")
 *                 .deviceTypeWeb("DENY")
 *                 .deviceTypeWindows("DENY")
 *                 .deviceTypeZeroclient("DENY")
 *                 .build())
 *             .workspaceCreationProperties(DirectoryWorkspaceCreationPropertiesArgs.builder()
 *                 .customSecurityGroupId(aws_security_group.example().id())
 *                 .defaultOu("OU=AWS,DC=Workgroup,DC=Example,DC=com")
 *                 .enableInternetAccess(true)
 *                 .enableMaintenanceMode(true)
 *                 .userEnabledAsLocalAdministrator(true)
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(
 *                     workspacesDefaultServiceAccess,
 *                     workspacesDefaultSelfServiceAccess)
 *                 .build());
 *         var exampleA = new Subnet("exampleA", SubnetArgs.builder()
 *             .vpcId(exampleVpc.id())
 *             .availabilityZone("us-east-1a")
 *             .cidrBlock("10.0.0.0/24")
 *             .build());
 *         var exampleB = new Subnet("exampleB", SubnetArgs.builder()
 *             .vpcId(exampleVpc.id())
 *             .availabilityZone("us-east-1b")
 *             .cidrBlock("10.0.1.0/24")
 *             .build());
 *         var exampleDirectoryservice_directoryDirectory = new Directory("exampleDirectoryservice/directoryDirectory", DirectoryArgs.builder()
 *             .name("corp.example.com")
 *             .password("#S1ncerely")
 *             .size("Small")
 *             .vpcSettings(DirectoryVpcSettingsArgs.builder()
 *                 .vpcId(exampleVpc.id())
 *                 .subnetIds(
 *                     exampleA.id(),
 *                     exampleB.id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### IP Groups
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.workspaces.IpGroup;
 * import com.pulumi.aws.workspaces.Directory;
 * import com.pulumi.aws.workspaces.DirectoryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleIpGroup = new IpGroup("exampleIpGroup");
 *         var exampleDirectory = new Directory("exampleDirectory", DirectoryArgs.builder()
 *             .directoryId(aws_directory_service_directory.example().id())
 *             .ipGroupIds(exampleIpGroup.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Workspaces directory using the directory ID. For example:
 * ```sh
 *  $ pulumi import aws:workspaces/directory:Directory main d-4444444444
 * ```
 *
 */
public class Directory internal constructor(
    override val javaResource: com.pulumi.aws.workspaces.Directory,
) : KotlinCustomResource(javaResource, DirectoryMapper) {
    /**
     * The directory alias.
     */
    public val alias: Output<String>
        get() = javaResource.alias().applyValue({ args0 -> args0 })

    /**
     * The user name for the service account.
     */
    public val customerUserName: Output<String>
        get() = javaResource.customerUserName().applyValue({ args0 -> args0 })

    /**
     * The directory identifier for registration in WorkSpaces service.
     */
    public val directoryId: Output<String>
        get() = javaResource.directoryId().applyValue({ args0 -> args0 })

    /**
     * The name of the directory.
     */
    public val directoryName: Output<String>
        get() = javaResource.directoryName().applyValue({ args0 -> args0 })

    /**
     * The directory type.
     */
    public val directoryType: Output<String>
        get() = javaResource.directoryType().applyValue({ args0 -> args0 })

    /**
     * The IP addresses of the DNS servers for the directory.
     */
    public val dnsIpAddresses: Output<List<String>>
        get() = javaResource.dnsIpAddresses().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The identifier of the IAM role. This is the role that allows Amazon WorkSpaces to make calls to other services, such as Amazon EC2, on your behalf.
     */
    public val iamRoleId: Output<String>
        get() = javaResource.iamRoleId().applyValue({ args0 -> args0 })

    /**
     * The identifiers of the IP access control groups associated with the directory.
     */
    public val ipGroupIds: Output<List<String>>
        get() = javaResource.ipGroupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The registration code for the directory. This is the code that users enter in their Amazon WorkSpaces client application to connect to the directory.
     */
    public val registrationCode: Output<String>
        get() = javaResource.registrationCode().applyValue({ args0 -> args0 })

    /**
     * Permissions to enable or disable self-service capabilities. Defined below.
     */
    public val selfServicePermissions: Output<DirectorySelfServicePermissions>
        get() = javaResource.selfServicePermissions().applyValue({ args0 ->
            args0.let({ args0 ->
                directorySelfServicePermissionsToKotlin(args0)
            })
        })

    /**
     * The identifiers of the subnets where the directory resides.
     */
    public val subnetIds: Output<List<String>>
        get() = javaResource.subnetIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A map of tags assigned to the WorkSpaces directory. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Specifies which devices and operating systems users can use to access their WorkSpaces. Defined below.
     */
    public val workspaceAccessProperties: Output<DirectoryWorkspaceAccessProperties>
        get() = javaResource.workspaceAccessProperties().applyValue({ args0 ->
            args0.let({ args0 ->
                directoryWorkspaceAccessPropertiesToKotlin(args0)
            })
        })

    /**
     * Default properties that are used for creating WorkSpaces. Defined below.
     */
    public val workspaceCreationProperties: Output<DirectoryWorkspaceCreationProperties>
        get() = javaResource.workspaceCreationProperties().applyValue({ args0 ->
            args0.let({ args0 ->
                directoryWorkspaceCreationPropertiesToKotlin(args0)
            })
        })

    /**
     * The identifier of the security group that is assigned to new WorkSpaces.
     */
    public val workspaceSecurityGroupId: Output<String>
        get() = javaResource.workspaceSecurityGroupId().applyValue({ args0 -> args0 })
}

public object DirectoryMapper : ResourceMapper<Directory> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.workspaces.Directory::class == javaResource::class

    override fun map(javaResource: Resource): Directory = Directory(
        javaResource as
            com.pulumi.aws.workspaces.Directory,
    )
}

/**
 * @see [Directory].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Directory].
 */
public suspend fun directory(name: String, block: suspend DirectoryResourceBuilder.() -> Unit):
    Directory {
    val builder = DirectoryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Directory].
 * @param name The _unique_ name of the resulting resource.
 */
public fun directory(name: String): Directory {
    val builder = DirectoryResourceBuilder()
    builder.name(name)
    return builder.build()
}
