@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.workspaces.kotlin

import com.pulumi.aws.workspaces.DirectoryArgs.builder
import com.pulumi.aws.workspaces.kotlin.inputs.DirectorySelfServicePermissionsArgs
import com.pulumi.aws.workspaces.kotlin.inputs.DirectorySelfServicePermissionsArgsBuilder
import com.pulumi.aws.workspaces.kotlin.inputs.DirectoryWorkspaceAccessPropertiesArgs
import com.pulumi.aws.workspaces.kotlin.inputs.DirectoryWorkspaceAccessPropertiesArgsBuilder
import com.pulumi.aws.workspaces.kotlin.inputs.DirectoryWorkspaceCreationPropertiesArgs
import com.pulumi.aws.workspaces.kotlin.inputs.DirectoryWorkspaceCreationPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a WorkSpaces directory in AWS WorkSpaces Service.
 * > **NOTE:** AWS WorkSpaces service requires [`workspaces_DefaultRole`](https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role) IAM role to operate normally.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import com.pulumi.aws.workspaces.Directory;
 * import com.pulumi.aws.workspaces.DirectoryArgs;
 * import com.pulumi.aws.workspaces.inputs.DirectorySelfServicePermissionsArgs;
 * import com.pulumi.aws.workspaces.inputs.DirectoryWorkspaceAccessPropertiesArgs;
 * import com.pulumi.aws.workspaces.inputs.DirectoryWorkspaceCreationPropertiesArgs;
 * import com.pulumi.aws.directoryservice.Directory;
 * import com.pulumi.aws.directoryservice.DirectoryArgs;
 * import com.pulumi.aws.directoryservice.inputs.DirectoryVpcSettingsArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var workspaces = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("workspaces.amazonaws.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         var workspacesDefault = new Role("workspacesDefault", RoleArgs.builder()
 *             .assumeRolePolicy(workspaces.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var workspacesDefaultServiceAccess = new RolePolicyAttachment("workspacesDefaultServiceAccess", RolePolicyAttachmentArgs.builder()
 *             .role(workspacesDefault.name())
 *             .policyArn("arn:aws:iam::aws:policy/AmazonWorkSpacesServiceAccess")
 *             .build());
 *         var workspacesDefaultSelfServiceAccess = new RolePolicyAttachment("workspacesDefaultSelfServiceAccess", RolePolicyAttachmentArgs.builder()
 *             .role(workspacesDefault.name())
 *             .policyArn("arn:aws:iam::aws:policy/AmazonWorkSpacesSelfServiceAccess")
 *             .build());
 *         var exampleVpc = new Vpc("exampleVpc", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var exampleC = new Subnet("exampleC", SubnetArgs.builder()
 *             .vpcId(exampleVpc.id())
 *             .availabilityZone("us-east-1c")
 *             .cidrBlock("10.0.2.0/24")
 *             .build());
 *         var exampleD = new Subnet("exampleD", SubnetArgs.builder()
 *             .vpcId(exampleVpc.id())
 *             .availabilityZone("us-east-1d")
 *             .cidrBlock("10.0.3.0/24")
 *             .build());
 *         var exampleDirectory = new Directory("exampleDirectory", DirectoryArgs.builder()
 *             .directoryId(exampleDirectoryservice / directoryDirectory.id())
 *             .subnetIds(
 *                 exampleC.id(),
 *                 exampleD.id())
 *             .tags(Map.of("Example", true))
 *             .selfServicePermissions(DirectorySelfServicePermissionsArgs.builder()
 *                 .changeComputeType(true)
 *                 .increaseVolumeSize(true)
 *                 .rebuildWorkspace(true)
 *                 .restartWorkspace(true)
 *                 .switchRunningMode(true)
 *                 .build())
 *             .workspaceAccessProperties(DirectoryWorkspaceAccessPropertiesArgs.builder()
 *                 .deviceTypeAndroid("ALLOW")
 *                 .deviceTypeChromeos("ALLOW")
 *                 .deviceTypeIos("ALLOW")
 *                 .deviceTypeLinux("DENY")
 *                 .deviceTypeOsx("ALLOW")
 *                 .deviceTypeWeb("DENY")
 *                 .deviceTypeWindows("DENY")
 *                 .deviceTypeZeroclient("DENY")
 *                 .build())
 *             .workspaceCreationProperties(DirectoryWorkspaceCreationPropertiesArgs.builder()
 *                 .customSecurityGroupId(aws_security_group.example().id())
 *                 .defaultOu("OU=AWS,DC=Workgroup,DC=Example,DC=com")
 *                 .enableInternetAccess(true)
 *                 .enableMaintenanceMode(true)
 *                 .userEnabledAsLocalAdministrator(true)
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(
 *                     workspacesDefaultServiceAccess,
 *                     workspacesDefaultSelfServiceAccess)
 *                 .build());
 *         var exampleA = new Subnet("exampleA", SubnetArgs.builder()
 *             .vpcId(exampleVpc.id())
 *             .availabilityZone("us-east-1a")
 *             .cidrBlock("10.0.0.0/24")
 *             .build());
 *         var exampleB = new Subnet("exampleB", SubnetArgs.builder()
 *             .vpcId(exampleVpc.id())
 *             .availabilityZone("us-east-1b")
 *             .cidrBlock("10.0.1.0/24")
 *             .build());
 *         var exampleDirectoryservice_directoryDirectory = new Directory("exampleDirectoryservice/directoryDirectory", DirectoryArgs.builder()
 *             .name("corp.example.com")
 *             .password("#S1ncerely")
 *             .size("Small")
 *             .vpcSettings(DirectoryVpcSettingsArgs.builder()
 *                 .vpcId(exampleVpc.id())
 *                 .subnetIds(
 *                     exampleA.id(),
 *                     exampleB.id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### IP Groups
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.workspaces.IpGroup;
 * import com.pulumi.aws.workspaces.Directory;
 * import com.pulumi.aws.workspaces.DirectoryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleIpGroup = new IpGroup("exampleIpGroup");
 *         var exampleDirectory = new Directory("exampleDirectory", DirectoryArgs.builder()
 *             .directoryId(aws_directory_service_directory.example().id())
 *             .ipGroupIds(exampleIpGroup.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Workspaces directory using the directory ID. For example:
 * ```sh
 *  $ pulumi import aws:workspaces/directory:Directory main d-4444444444
 * ```
 * @property directoryId The directory identifier for registration in WorkSpaces service.
 * @property ipGroupIds The identifiers of the IP access control groups associated with the directory.
 * @property selfServicePermissions Permissions to enable or disable self-service capabilities. Defined below.
 * @property subnetIds The identifiers of the subnets where the directory resides.
 * @property tags A map of tags assigned to the WorkSpaces directory. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property workspaceAccessProperties Specifies which devices and operating systems users can use to access their WorkSpaces. Defined below.
 * @property workspaceCreationProperties Default properties that are used for creating WorkSpaces. Defined below.
 */
public data class DirectoryArgs(
    public val directoryId: Output<String>? = null,
    public val ipGroupIds: Output<List<String>>? = null,
    public val selfServicePermissions: Output<DirectorySelfServicePermissionsArgs>? = null,
    public val subnetIds: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workspaceAccessProperties: Output<DirectoryWorkspaceAccessPropertiesArgs>? = null,
    public val workspaceCreationProperties: Output<DirectoryWorkspaceCreationPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.workspaces.DirectoryArgs> {
    override fun toJava(): com.pulumi.aws.workspaces.DirectoryArgs =
        com.pulumi.aws.workspaces.DirectoryArgs.builder()
            .directoryId(directoryId?.applyValue({ args0 -> args0 }))
            .ipGroupIds(ipGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .selfServicePermissions(
                selfServicePermissions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workspaceAccessProperties(
                workspaceAccessProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .workspaceCreationProperties(
                workspaceCreationProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DirectoryArgs].
 */
@PulumiTagMarker
public class DirectoryArgsBuilder internal constructor() {
    private var directoryId: Output<String>? = null

    private var ipGroupIds: Output<List<String>>? = null

    private var selfServicePermissions: Output<DirectorySelfServicePermissionsArgs>? = null

    private var subnetIds: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workspaceAccessProperties: Output<DirectoryWorkspaceAccessPropertiesArgs>? = null

    private var workspaceCreationProperties: Output<DirectoryWorkspaceCreationPropertiesArgs>? = null

    /**
     * @param value The directory identifier for registration in WorkSpaces service.
     */
    @JvmName("sgqeoehujeokmcpi")
    public suspend fun directoryId(`value`: Output<String>) {
        this.directoryId = value
    }

    /**
     * @param value The identifiers of the IP access control groups associated with the directory.
     */
    @JvmName("vbaaqsaopxevuvgx")
    public suspend fun ipGroupIds(`value`: Output<List<String>>) {
        this.ipGroupIds = value
    }

    @JvmName("rxnguysiexpucdjd")
    public suspend fun ipGroupIds(vararg values: Output<String>) {
        this.ipGroupIds = Output.all(values.asList())
    }

    /**
     * @param values The identifiers of the IP access control groups associated with the directory.
     */
    @JvmName("qqmlfobbqxwurmwh")
    public suspend fun ipGroupIds(values: List<Output<String>>) {
        this.ipGroupIds = Output.all(values)
    }

    /**
     * @param value Permissions to enable or disable self-service capabilities. Defined below.
     */
    @JvmName("vvlrvwcvtgqcumkn")
    public suspend fun selfServicePermissions(`value`: Output<DirectorySelfServicePermissionsArgs>) {
        this.selfServicePermissions = value
    }

    /**
     * @param value The identifiers of the subnets where the directory resides.
     */
    @JvmName("avanflmsepdagudi")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("gloihxeorbiyqtjk")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values The identifiers of the subnets where the directory resides.
     */
    @JvmName("pdtksldalopmxegy")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value A map of tags assigned to the WorkSpaces directory. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("npukfcltgimgwebr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies which devices and operating systems users can use to access their WorkSpaces. Defined below.
     */
    @JvmName("xwoycnrkwtylquto")
    public suspend
    fun workspaceAccessProperties(`value`: Output<DirectoryWorkspaceAccessPropertiesArgs>) {
        this.workspaceAccessProperties = value
    }

    /**
     * @param value Default properties that are used for creating WorkSpaces. Defined below.
     */
    @JvmName("mpjpmyesrxdfowmv")
    public suspend
    fun workspaceCreationProperties(`value`: Output<DirectoryWorkspaceCreationPropertiesArgs>) {
        this.workspaceCreationProperties = value
    }

    /**
     * @param value The directory identifier for registration in WorkSpaces service.
     */
    @JvmName("pwsvcpjcwnvypcde")
    public suspend fun directoryId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directoryId = mapped
    }

    /**
     * @param value The identifiers of the IP access control groups associated with the directory.
     */
    @JvmName("suusvgusbwdviqdc")
    public suspend fun ipGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipGroupIds = mapped
    }

    /**
     * @param values The identifiers of the IP access control groups associated with the directory.
     */
    @JvmName("wqdtwuhsttutrwix")
    public suspend fun ipGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipGroupIds = mapped
    }

    /**
     * @param value Permissions to enable or disable self-service capabilities. Defined below.
     */
    @JvmName("swykrxjmggxjkjbd")
    public suspend fun selfServicePermissions(`value`: DirectorySelfServicePermissionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selfServicePermissions = mapped
    }

    /**
     * @param argument Permissions to enable or disable self-service capabilities. Defined below.
     */
    @JvmName("tleirhpanrqakuug")
    public suspend
    fun selfServicePermissions(argument: suspend DirectorySelfServicePermissionsArgsBuilder.() -> Unit) {
        val toBeMapped = DirectorySelfServicePermissionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.selfServicePermissions = mapped
    }

    /**
     * @param value The identifiers of the subnets where the directory resides.
     */
    @JvmName("wliymnlbcniqyfyj")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values The identifiers of the subnets where the directory resides.
     */
    @JvmName("dnsqpbeapevwwnjl")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value A map of tags assigned to the WorkSpaces directory. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dfaopgcbiwqqitju")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags assigned to the WorkSpaces directory. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ukmcjdcrivlpslux")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Specifies which devices and operating systems users can use to access their WorkSpaces. Defined below.
     */
    @JvmName("obseewncvntvhbpi")
    public suspend fun workspaceAccessProperties(`value`: DirectoryWorkspaceAccessPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceAccessProperties = mapped
    }

    /**
     * @param argument Specifies which devices and operating systems users can use to access their WorkSpaces. Defined below.
     */
    @JvmName("mcisnwduwbvobqcy")
    public suspend
    fun workspaceAccessProperties(argument: suspend DirectoryWorkspaceAccessPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = DirectoryWorkspaceAccessPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.workspaceAccessProperties = mapped
    }

    /**
     * @param value Default properties that are used for creating WorkSpaces. Defined below.
     */
    @JvmName("rxrdfyacjlevfqnl")
    public suspend
    fun workspaceCreationProperties(`value`: DirectoryWorkspaceCreationPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceCreationProperties = mapped
    }

    /**
     * @param argument Default properties that are used for creating WorkSpaces. Defined below.
     */
    @JvmName("etnyblttjajrexnt")
    public suspend
    fun workspaceCreationProperties(argument: suspend DirectoryWorkspaceCreationPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = DirectoryWorkspaceCreationPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.workspaceCreationProperties = mapped
    }

    internal fun build(): DirectoryArgs = DirectoryArgs(
        directoryId = directoryId,
        ipGroupIds = ipGroupIds,
        selfServicePermissions = selfServicePermissions,
        subnetIds = subnetIds,
        tags = tags,
        workspaceAccessProperties = workspaceAccessProperties,
        workspaceCreationProperties = workspaceCreationProperties,
    )
}
