@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.workspaces.kotlin

import com.pulumi.aws.workspaces.kotlin.outputs.IpGroupRule
import com.pulumi.aws.workspaces.kotlin.outputs.IpGroupRule.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [IpGroup].
 */
@PulumiTagMarker
public class IpGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IpGroupArgs = IpGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IpGroupArgsBuilder.() -> Unit) {
        val builder = IpGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): IpGroup {
        val builtJavaResource = com.pulumi.aws.workspaces.IpGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IpGroup(builtJavaResource)
    }
}

/**
 * Provides an IP access control group in AWS WorkSpaces Service
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.workspaces.IpGroup;
 * import com.pulumi.aws.workspaces.IpGroupArgs;
 * import com.pulumi.aws.workspaces.inputs.IpGroupRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var contractors = new IpGroup("contractors", IpGroupArgs.builder()
 *             .description("Contractors IP access control group")
 *             .rules(
 *                 IpGroupRuleArgs.builder()
 *                     .description("NY")
 *                     .source("150.24.14.0/24")
 *                     .build(),
 *                 IpGroupRuleArgs.builder()
 *                     .description("LA")
 *                     .source("125.191.14.85/32")
 *                     .build(),
 *                 IpGroupRuleArgs.builder()
 *                     .description("STL")
 *                     .source("44.98.100.0/24")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import WorkSpaces IP groups using their GroupID. For example:
 * ```sh
 *  $ pulumi import aws:workspaces/ipGroup:IpGroup example wsipg-488lrtl3k
 * ```
 *
 */
public class IpGroup internal constructor(
    override val javaResource: com.pulumi.aws.workspaces.IpGroup,
) : KotlinCustomResource(javaResource, IpGroupMapper) {
    /**
     * The description of the IP group.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the IP group.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * One or more pairs specifying the IP group rule (in CIDR format) from which web requests originate.
     */
    public val rules: Output<List<IpGroupRule>>?
        get() = javaResource.rules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the WorkSpaces directory. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object IpGroupMapper : ResourceMapper<IpGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.workspaces.IpGroup::class == javaResource::class

    override fun map(javaResource: Resource): IpGroup = IpGroup(
        javaResource as
            com.pulumi.aws.workspaces.IpGroup,
    )
}

/**
 * @see [IpGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IpGroup].
 */
public suspend fun ipGroup(name: String, block: suspend IpGroupResourceBuilder.() -> Unit):
    IpGroup {
    val builder = IpGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IpGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ipGroup(name: String): IpGroup {
    val builder = IpGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
