@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.workspaces.kotlin

import com.pulumi.aws.workspaces.IpGroupArgs.builder
import com.pulumi.aws.workspaces.kotlin.inputs.IpGroupRuleArgs
import com.pulumi.aws.workspaces.kotlin.inputs.IpGroupRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an IP access control group in AWS WorkSpaces Service
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.workspaces.IpGroup;
 * import com.pulumi.aws.workspaces.IpGroupArgs;
 * import com.pulumi.aws.workspaces.inputs.IpGroupRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var contractors = new IpGroup("contractors", IpGroupArgs.builder()
 *             .description("Contractors IP access control group")
 *             .rules(
 *                 IpGroupRuleArgs.builder()
 *                     .description("NY")
 *                     .source("150.24.14.0/24")
 *                     .build(),
 *                 IpGroupRuleArgs.builder()
 *                     .description("LA")
 *                     .source("125.191.14.85/32")
 *                     .build(),
 *                 IpGroupRuleArgs.builder()
 *                     .description("STL")
 *                     .source("44.98.100.0/24")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import WorkSpaces IP groups using their GroupID. For example:
 * ```sh
 *  $ pulumi import aws:workspaces/ipGroup:IpGroup example wsipg-488lrtl3k
 * ```
 * @property description The description of the IP group.
 * @property name The name of the IP group.
 * @property rules One or more pairs specifying the IP group rule (in CIDR format) from which web requests originate.
 * @property tags A map of tags assigned to the WorkSpaces directory. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class IpGroupArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val rules: Output<List<IpGroupRuleArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.workspaces.IpGroupArgs> {
    override fun toJava(): com.pulumi.aws.workspaces.IpGroupArgs =
        com.pulumi.aws.workspaces.IpGroupArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .rules(rules?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [IpGroupArgs].
 */
@PulumiTagMarker
public class IpGroupArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var rules: Output<List<IpGroupRuleArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The description of the IP group.
     */
    @JvmName("kvwifglwufwrqgnp")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the IP group.
     */
    @JvmName("geiwkuwqpnpcgfku")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value One or more pairs specifying the IP group rule (in CIDR format) from which web requests originate.
     */
    @JvmName("suknetpsxuqofpgu")
    public suspend fun rules(`value`: Output<List<IpGroupRuleArgs>>) {
        this.rules = value
    }

    @JvmName("djpcgimcpaaquuqd")
    public suspend fun rules(vararg values: Output<IpGroupRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values One or more pairs specifying the IP group rule (in CIDR format) from which web requests originate.
     */
    @JvmName("ugxxfqbskicmfbod")
    public suspend fun rules(values: List<Output<IpGroupRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value A map of tags assigned to the WorkSpaces directory. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("plokgtmnnftywwpe")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The description of the IP group.
     */
    @JvmName("cskqoyypjdclubsv")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the IP group.
     */
    @JvmName("ccktyudmmgtisjvh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value One or more pairs specifying the IP group rule (in CIDR format) from which web requests originate.
     */
    @JvmName("wpmiolwbwmttjblv")
    public suspend fun rules(`value`: List<IpGroupRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument One or more pairs specifying the IP group rule (in CIDR format) from which web requests originate.
     */
    @JvmName("uukplplgtmjwaxbv")
    public suspend fun rules(argument: List<suspend IpGroupRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IpGroupRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument One or more pairs specifying the IP group rule (in CIDR format) from which web requests originate.
     */
    @JvmName("kpsmvupmlmpiymoh")
    public suspend fun rules(vararg argument: suspend IpGroupRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { IpGroupRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument One or more pairs specifying the IP group rule (in CIDR format) from which web requests originate.
     */
    @JvmName("owhdrhpiocqijwkj")
    public suspend fun rules(argument: suspend IpGroupRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IpGroupRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values One or more pairs specifying the IP group rule (in CIDR format) from which web requests originate.
     */
    @JvmName("enfvwdwhxemjpjbj")
    public suspend fun rules(vararg values: IpGroupRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param value A map of tags assigned to the WorkSpaces directory. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("falwywptheqnguhh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags assigned to the WorkSpaces directory. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ewgauscdsjwltxcf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): IpGroupArgs = IpGroupArgs(
        description = description,
        name = name,
        rules = rules,
        tags = tags,
    )
}
