@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.workspaces.kotlin

import com.pulumi.aws.workspaces.kotlin.outputs.WorkspaceWorkspaceProperties
import com.pulumi.aws.workspaces.kotlin.outputs.WorkspaceWorkspaceProperties.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Workspace].
 */
@PulumiTagMarker
public class WorkspaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkspaceArgs = WorkspaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkspaceArgsBuilder.() -> Unit) {
        val builder = WorkspaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Workspace {
        val builtJavaResource = com.pulumi.aws.workspaces.Workspace(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Workspace(builtJavaResource)
    }
}

/**
 * Provides a workspace in [AWS Workspaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces.html) Service
 * > **NOTE:** AWS WorkSpaces service requires [`workspaces_DefaultRole`](https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role) IAM role to operate normally.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.workspaces.WorkspacesFunctions;
 * import com.pulumi.aws.workspaces.inputs.GetBundleArgs;
 * import com.pulumi.aws.workspaces.Workspace;
 * import com.pulumi.aws.workspaces.WorkspaceArgs;
 * import com.pulumi.aws.workspaces.inputs.WorkspaceWorkspacePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var valueWindows10 = WorkspacesFunctions.getBundle(GetBundleArgs.builder()
 *             .bundleId("wsb-bh8rsxt14")
 *             .build());
 *         var example = new Workspace("example", WorkspaceArgs.builder()
 *             .directoryId(aws_workspaces_directory.example().id())
 *             .bundleId(valueWindows10.applyValue(getBundleResult -> getBundleResult.id()))
 *             .userName("john.doe")
 *             .rootVolumeEncryptionEnabled(true)
 *             .userVolumeEncryptionEnabled(true)
 *             .volumeEncryptionKey("alias/aws/workspaces")
 *             .workspaceProperties(WorkspaceWorkspacePropertiesArgs.builder()
 *                 .computeTypeName("VALUE")
 *                 .userVolumeSizeGib(10)
 *                 .rootVolumeSizeGib(80)
 *                 .runningMode("AUTO_STOP")
 *                 .runningModeAutoStopTimeoutInMinutes(60)
 *                 .build())
 *             .tags(Map.of("Department", "IT"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Workspaces using their ID. For example:
 * ```sh
 *  $ pulumi import aws:workspaces/workspace:Workspace example ws-9z9zmbkhv
 * ```
 *
 */
public class Workspace internal constructor(
    override val javaResource: com.pulumi.aws.workspaces.Workspace,
) : KotlinCustomResource(javaResource, WorkspaceMapper) {
    /**
     * The ID of the bundle for the WorkSpace.
     */
    public val bundleId: Output<String>
        get() = javaResource.bundleId().applyValue({ args0 -> args0 })

    /**
     * The name of the WorkSpace, as seen by the operating system.
     */
    public val computerName: Output<String>
        get() = javaResource.computerName().applyValue({ args0 -> args0 })

    /**
     * The ID of the directory for the WorkSpace.
     */
    public val directoryId: Output<String>
        get() = javaResource.directoryId().applyValue({ args0 -> args0 })

    /**
     * The IP address of the WorkSpace.
     */
    public val ipAddress: Output<String>
        get() = javaResource.ipAddress().applyValue({ args0 -> args0 })

    /**
     * Indicates whether the data stored on the root volume is encrypted.
     */
    public val rootVolumeEncryptionEnabled: Output<Boolean>?
        get() = javaResource.rootVolumeEncryptionEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The operational state of the WorkSpace.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * The tags for the WorkSpace. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The user name of the user for the WorkSpace. This user name must exist in the directory for the WorkSpace.
     */
    public val userName: Output<String>
        get() = javaResource.userName().applyValue({ args0 -> args0 })

    /**
     * Indicates whether the data stored on the user volume is encrypted.
     */
    public val userVolumeEncryptionEnabled: Output<Boolean>?
        get() = javaResource.userVolumeEncryptionEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The symmetric AWS KMS customer master key (CMK) used to encrypt data stored on your WorkSpace. Amazon WorkSpaces does not support asymmetric CMKs.
     */
    public val volumeEncryptionKey: Output<String>?
        get() = javaResource.volumeEncryptionKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The WorkSpace properties.
     */
    public val workspaceProperties: Output<WorkspaceWorkspaceProperties>
        get() = javaResource.workspaceProperties().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })
}

public object WorkspaceMapper : ResourceMapper<Workspace> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.workspaces.Workspace::class == javaResource::class

    override fun map(javaResource: Resource): Workspace = Workspace(
        javaResource as
            com.pulumi.aws.workspaces.Workspace,
    )
}

/**
 * @see [Workspace].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Workspace].
 */
public suspend fun workspace(name: String, block: suspend WorkspaceResourceBuilder.() -> Unit):
    Workspace {
    val builder = WorkspaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Workspace].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workspace(name: String): Workspace {
    val builder = WorkspaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
