@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.workspaces.kotlin

import com.pulumi.aws.workspaces.WorkspaceArgs.builder
import com.pulumi.aws.workspaces.kotlin.inputs.WorkspaceWorkspacePropertiesArgs
import com.pulumi.aws.workspaces.kotlin.inputs.WorkspaceWorkspacePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a workspace in [AWS Workspaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces.html) Service
 * > **NOTE:** AWS WorkSpaces service requires [`workspaces_DefaultRole`](https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role) IAM role to operate normally.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.workspaces.WorkspacesFunctions;
 * import com.pulumi.aws.workspaces.inputs.GetBundleArgs;
 * import com.pulumi.aws.workspaces.Workspace;
 * import com.pulumi.aws.workspaces.WorkspaceArgs;
 * import com.pulumi.aws.workspaces.inputs.WorkspaceWorkspacePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var valueWindows10 = WorkspacesFunctions.getBundle(GetBundleArgs.builder()
 *             .bundleId("wsb-bh8rsxt14")
 *             .build());
 *         var example = new Workspace("example", WorkspaceArgs.builder()
 *             .directoryId(aws_workspaces_directory.example().id())
 *             .bundleId(valueWindows10.applyValue(getBundleResult -> getBundleResult.id()))
 *             .userName("john.doe")
 *             .rootVolumeEncryptionEnabled(true)
 *             .userVolumeEncryptionEnabled(true)
 *             .volumeEncryptionKey("alias/aws/workspaces")
 *             .workspaceProperties(WorkspaceWorkspacePropertiesArgs.builder()
 *                 .computeTypeName("VALUE")
 *                 .userVolumeSizeGib(10)
 *                 .rootVolumeSizeGib(80)
 *                 .runningMode("AUTO_STOP")
 *                 .runningModeAutoStopTimeoutInMinutes(60)
 *                 .build())
 *             .tags(Map.of("Department", "IT"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Workspaces using their ID. For example:
 * ```sh
 *  $ pulumi import aws:workspaces/workspace:Workspace example ws-9z9zmbkhv
 * ```
 * @property bundleId The ID of the bundle for the WorkSpace.
 * @property directoryId The ID of the directory for the WorkSpace.
 * @property rootVolumeEncryptionEnabled Indicates whether the data stored on the root volume is encrypted.
 * @property tags The tags for the WorkSpace. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property userName The user name of the user for the WorkSpace. This user name must exist in the directory for the WorkSpace.
 * @property userVolumeEncryptionEnabled Indicates whether the data stored on the user volume is encrypted.
 * @property volumeEncryptionKey The symmetric AWS KMS customer master key (CMK) used to encrypt data stored on your WorkSpace. Amazon WorkSpaces does not support asymmetric CMKs.
 * @property workspaceProperties The WorkSpace properties.
 */
public data class WorkspaceArgs(
    public val bundleId: Output<String>? = null,
    public val directoryId: Output<String>? = null,
    public val rootVolumeEncryptionEnabled: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userName: Output<String>? = null,
    public val userVolumeEncryptionEnabled: Output<Boolean>? = null,
    public val volumeEncryptionKey: Output<String>? = null,
    public val workspaceProperties: Output<WorkspaceWorkspacePropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.workspaces.WorkspaceArgs> {
    override fun toJava(): com.pulumi.aws.workspaces.WorkspaceArgs =
        com.pulumi.aws.workspaces.WorkspaceArgs.builder()
            .bundleId(bundleId?.applyValue({ args0 -> args0 }))
            .directoryId(directoryId?.applyValue({ args0 -> args0 }))
            .rootVolumeEncryptionEnabled(rootVolumeEncryptionEnabled?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userName(userName?.applyValue({ args0 -> args0 }))
            .userVolumeEncryptionEnabled(userVolumeEncryptionEnabled?.applyValue({ args0 -> args0 }))
            .volumeEncryptionKey(volumeEncryptionKey?.applyValue({ args0 -> args0 }))
            .workspaceProperties(
                workspaceProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [WorkspaceArgs].
 */
@PulumiTagMarker
public class WorkspaceArgsBuilder internal constructor() {
    private var bundleId: Output<String>? = null

    private var directoryId: Output<String>? = null

    private var rootVolumeEncryptionEnabled: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userName: Output<String>? = null

    private var userVolumeEncryptionEnabled: Output<Boolean>? = null

    private var volumeEncryptionKey: Output<String>? = null

    private var workspaceProperties: Output<WorkspaceWorkspacePropertiesArgs>? = null

    /**
     * @param value The ID of the bundle for the WorkSpace.
     */
    @JvmName("rahttiadykepejvh")
    public suspend fun bundleId(`value`: Output<String>) {
        this.bundleId = value
    }

    /**
     * @param value The ID of the directory for the WorkSpace.
     */
    @JvmName("vlveylimdkvwdelo")
    public suspend fun directoryId(`value`: Output<String>) {
        this.directoryId = value
    }

    /**
     * @param value Indicates whether the data stored on the root volume is encrypted.
     */
    @JvmName("smdcwhiosstwipsh")
    public suspend fun rootVolumeEncryptionEnabled(`value`: Output<Boolean>) {
        this.rootVolumeEncryptionEnabled = value
    }

    /**
     * @param value The tags for the WorkSpace. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kyidexjbxhfopwqq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The user name of the user for the WorkSpace. This user name must exist in the directory for the WorkSpace.
     */
    @JvmName("srontfrhoegvhjmh")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value Indicates whether the data stored on the user volume is encrypted.
     */
    @JvmName("xprwjufylvwnixdx")
    public suspend fun userVolumeEncryptionEnabled(`value`: Output<Boolean>) {
        this.userVolumeEncryptionEnabled = value
    }

    /**
     * @param value The symmetric AWS KMS customer master key (CMK) used to encrypt data stored on your WorkSpace. Amazon WorkSpaces does not support asymmetric CMKs.
     */
    @JvmName("rrpqpqwimostqgdp")
    public suspend fun volumeEncryptionKey(`value`: Output<String>) {
        this.volumeEncryptionKey = value
    }

    /**
     * @param value The WorkSpace properties.
     */
    @JvmName("xobsvabknpspdkkc")
    public suspend fun workspaceProperties(`value`: Output<WorkspaceWorkspacePropertiesArgs>) {
        this.workspaceProperties = value
    }

    /**
     * @param value The ID of the bundle for the WorkSpace.
     */
    @JvmName("tlbayogfnhinkqaf")
    public suspend fun bundleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bundleId = mapped
    }

    /**
     * @param value The ID of the directory for the WorkSpace.
     */
    @JvmName("xiqgyhieaagjmufv")
    public suspend fun directoryId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directoryId = mapped
    }

    /**
     * @param value Indicates whether the data stored on the root volume is encrypted.
     */
    @JvmName("ckwqfedxiggdtpvb")
    public suspend fun rootVolumeEncryptionEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rootVolumeEncryptionEnabled = mapped
    }

    /**
     * @param value The tags for the WorkSpace. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jbedhafxmqpdkehc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags for the WorkSpace. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nmiyxpdbkroqatcc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The user name of the user for the WorkSpace. This user name must exist in the directory for the WorkSpace.
     */
    @JvmName("nxhlumlhejivowos")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    /**
     * @param value Indicates whether the data stored on the user volume is encrypted.
     */
    @JvmName("aroyyxnkqbstunbn")
    public suspend fun userVolumeEncryptionEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userVolumeEncryptionEnabled = mapped
    }

    /**
     * @param value The symmetric AWS KMS customer master key (CMK) used to encrypt data stored on your WorkSpace. Amazon WorkSpaces does not support asymmetric CMKs.
     */
    @JvmName("mptldnjpoysiggsa")
    public suspend fun volumeEncryptionKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeEncryptionKey = mapped
    }

    /**
     * @param value The WorkSpace properties.
     */
    @JvmName("odspuoreybpbqtpk")
    public suspend fun workspaceProperties(`value`: WorkspaceWorkspacePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceProperties = mapped
    }

    /**
     * @param argument The WorkSpace properties.
     */
    @JvmName("jrishdrhlmkvmavj")
    public suspend
    fun workspaceProperties(argument: suspend WorkspaceWorkspacePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = WorkspaceWorkspacePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.workspaceProperties = mapped
    }

    internal fun build(): WorkspaceArgs = WorkspaceArgs(
        bundleId = bundleId,
        directoryId = directoryId,
        rootVolumeEncryptionEnabled = rootVolumeEncryptionEnabled,
        tags = tags,
        userName = userName,
        userVolumeEncryptionEnabled = userVolumeEncryptionEnabled,
        volumeEncryptionKey = volumeEncryptionKey,
        workspaceProperties = workspaceProperties,
    )
}
