@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.workspaces.kotlin

import com.pulumi.aws.workspaces.WorkspacesFunctions.getBundlePlain
import com.pulumi.aws.workspaces.WorkspacesFunctions.getDirectoryPlain
import com.pulumi.aws.workspaces.WorkspacesFunctions.getImagePlain
import com.pulumi.aws.workspaces.WorkspacesFunctions.getWorkspacePlain
import com.pulumi.aws.workspaces.kotlin.inputs.GetBundlePlainArgs
import com.pulumi.aws.workspaces.kotlin.inputs.GetBundlePlainArgsBuilder
import com.pulumi.aws.workspaces.kotlin.inputs.GetDirectoryPlainArgs
import com.pulumi.aws.workspaces.kotlin.inputs.GetDirectoryPlainArgsBuilder
import com.pulumi.aws.workspaces.kotlin.inputs.GetImagePlainArgs
import com.pulumi.aws.workspaces.kotlin.inputs.GetImagePlainArgsBuilder
import com.pulumi.aws.workspaces.kotlin.inputs.GetWorkspacePlainArgs
import com.pulumi.aws.workspaces.kotlin.inputs.GetWorkspacePlainArgsBuilder
import com.pulumi.aws.workspaces.kotlin.outputs.GetBundleResult
import com.pulumi.aws.workspaces.kotlin.outputs.GetDirectoryResult
import com.pulumi.aws.workspaces.kotlin.outputs.GetImageResult
import com.pulumi.aws.workspaces.kotlin.outputs.GetWorkspaceResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.workspaces.kotlin.outputs.GetBundleResult.Companion.toKotlin as getBundleResultToKotlin
import com.pulumi.aws.workspaces.kotlin.outputs.GetDirectoryResult.Companion.toKotlin as getDirectoryResultToKotlin
import com.pulumi.aws.workspaces.kotlin.outputs.GetImageResult.Companion.toKotlin as getImageResultToKotlin
import com.pulumi.aws.workspaces.kotlin.outputs.GetWorkspaceResult.Companion.toKotlin as getWorkspaceResultToKotlin

public object WorkspacesFunctions {
    /**
     * Retrieve information about an AWS WorkSpaces bundle.
     * ## Example Usage
     * ### By ID
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.workspaces.WorkspacesFunctions;
     * import com.pulumi.aws.workspaces.inputs.GetBundleArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = WorkspacesFunctions.getBundle(GetBundleArgs.builder()
     *             .bundleId("wsb-b0s22j3d7")
     *             .build());
     *     }
     * }
     * ```
     * ### By Owner & Name
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.workspaces.WorkspacesFunctions;
     * import com.pulumi.aws.workspaces.inputs.GetBundleArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = WorkspacesFunctions.getBundle(GetBundleArgs.builder()
     *             .name("Value with Windows 10 and Office 2016")
     *             .owner("AMAZON")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getBundle.
     * @return A collection of values returned by getBundle.
     */
    public suspend fun getBundle(argument: GetBundlePlainArgs): GetBundleResult =
        getBundleResultToKotlin(getBundlePlain(argument.toJava()).await())

    /**
     * @see [getBundle].
     * @param bundleId ID of the bundle.
     * @param name Name of the bundle. You cannot combine this parameter with `bundle_id`.
     * @param owner Owner of the bundles. You have to leave it blank for own bundles. You cannot combine this parameter with `bundle_id`.
     * @return A collection of values returned by getBundle.
     */
    public suspend fun getBundle(
        bundleId: String? = null,
        name: String? = null,
        owner: String? = null,
    ): GetBundleResult {
        val argument = GetBundlePlainArgs(
            bundleId = bundleId,
            name = name,
            owner = owner,
        )
        return getBundleResultToKotlin(getBundlePlain(argument.toJava()).await())
    }

    /**
     * @see [getBundle].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;workspaces&#46;kotlin&#46;inputs&#46;GetBundlePlainArgs].
     * @return A collection of values returned by getBundle.
     */
    public suspend fun getBundle(argument: suspend GetBundlePlainArgsBuilder.() -> Unit):
        GetBundleResult {
        val builder = GetBundlePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBundleResultToKotlin(getBundlePlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about an AWS WorkSpaces directory.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.workspaces.WorkspacesFunctions;
     * import com.pulumi.aws.workspaces.inputs.GetDirectoryArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = WorkspacesFunctions.getDirectory(GetDirectoryArgs.builder()
     *             .directoryId("d-9067783251")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getDirectory.
     * @return A collection of values returned by getDirectory.
     */
    public suspend fun getDirectory(argument: GetDirectoryPlainArgs): GetDirectoryResult =
        getDirectoryResultToKotlin(getDirectoryPlain(argument.toJava()).await())

    /**
     * @see [getDirectory].
     * @param directoryId Directory identifier for registration in WorkSpaces service.
     * @param tags A map of tags assigned to the WorkSpaces directory.
     * @return A collection of values returned by getDirectory.
     */
    public suspend fun getDirectory(directoryId: String, tags: Map<String, String>? = null):
        GetDirectoryResult {
        val argument = GetDirectoryPlainArgs(
            directoryId = directoryId,
            tags = tags,
        )
        return getDirectoryResultToKotlin(getDirectoryPlain(argument.toJava()).await())
    }

    /**
     * @see [getDirectory].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;workspaces&#46;kotlin&#46;inputs&#46;GetDirectoryPlainArgs].
     * @return A collection of values returned by getDirectory.
     */
    public suspend fun getDirectory(argument: suspend GetDirectoryPlainArgsBuilder.() -> Unit):
        GetDirectoryResult {
        val builder = GetDirectoryPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDirectoryResultToKotlin(getDirectoryPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get information about a Workspaces image.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.workspaces.WorkspacesFunctions;
     * import com.pulumi.aws.workspaces.inputs.GetImageArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = WorkspacesFunctions.getImage(GetImageArgs.builder()
     *             .imageId("wsi-ten5h0y19")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getImage.
     * @return A collection of values returned by getImage.
     */
    public suspend fun getImage(argument: GetImagePlainArgs): GetImageResult =
        getImageResultToKotlin(getImagePlain(argument.toJava()).await())

    /**
     * @see [getImage].
     * @param imageId ID of the image.
     * @return A collection of values returned by getImage.
     */
    public suspend fun getImage(imageId: String): GetImageResult {
        val argument = GetImagePlainArgs(
            imageId = imageId,
        )
        return getImageResultToKotlin(getImagePlain(argument.toJava()).await())
    }

    /**
     * @see [getImage].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;workspaces&#46;kotlin&#46;inputs&#46;GetImagePlainArgs].
     * @return A collection of values returned by getImage.
     */
    public suspend fun getImage(argument: suspend GetImagePlainArgsBuilder.() -> Unit):
        GetImageResult {
        val builder = GetImagePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getImageResultToKotlin(getImagePlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get information about a workspace in [AWS Workspaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces.html) Service.
     * ## Example Usage
     * ### Filter By Workspace ID
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.workspaces.WorkspacesFunctions;
     * import com.pulumi.aws.workspaces.inputs.GetWorkspaceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = WorkspacesFunctions.getWorkspace(GetWorkspaceArgs.builder()
     *             .workspaceId("ws-cj5xcxsz5")
     *             .build());
     *     }
     * }
     * ```
     * ### Filter By Directory ID & User Name
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.workspaces.WorkspacesFunctions;
     * import com.pulumi.aws.workspaces.inputs.GetWorkspaceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = WorkspacesFunctions.getWorkspace(GetWorkspaceArgs.builder()
     *             .directoryId("d-9967252f57")
     *             .userName("Example")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getWorkspace.
     * @return A collection of values returned by getWorkspace.
     */
    public suspend fun getWorkspace(argument: GetWorkspacePlainArgs): GetWorkspaceResult =
        getWorkspaceResultToKotlin(getWorkspacePlain(argument.toJava()).await())

    /**
     * @see [getWorkspace].
     * @param directoryId ID of the directory for the WorkSpace. You have to specify `user_name` along with `directory_id`. You cannot combine this parameter with `workspace_id`.
     * @param tags Tags for the WorkSpace.
     * @param userName User name of the user for the WorkSpace. This user name must exist in the directory for the WorkSpace. You cannot combine this parameter with `workspace_id`.
     * @param workspaceId ID of the WorkSpace. You cannot combine this parameter with `directory_id`.
     * @return A collection of values returned by getWorkspace.
     */
    public suspend fun getWorkspace(
        directoryId: String? = null,
        tags: Map<String, String>? = null,
        userName: String? = null,
        workspaceId: String? = null,
    ): GetWorkspaceResult {
        val argument = GetWorkspacePlainArgs(
            directoryId = directoryId,
            tags = tags,
            userName = userName,
            workspaceId = workspaceId,
        )
        return getWorkspaceResultToKotlin(getWorkspacePlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspace].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;workspaces&#46;kotlin&#46;inputs&#46;GetWorkspacePlainArgs].
     * @return A collection of values returned by getWorkspace.
     */
    public suspend fun getWorkspace(argument: suspend GetWorkspacePlainArgsBuilder.() -> Unit):
        GetWorkspaceResult {
        val builder = GetWorkspacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceResultToKotlin(getWorkspacePlain(builtArgument.toJava()).await())
    }
}
