@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.workspaces.kotlin.inputs

import com.pulumi.aws.workspaces.inputs.DirectorySelfServicePermissionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property changeComputeType Whether WorkSpaces directory users can change the compute type (bundle) for their workspace. Default `false`.
 * @property increaseVolumeSize Whether WorkSpaces directory users can increase the volume size of the drives on their workspace. Default `false`.
 * @property rebuildWorkspace Whether WorkSpaces directory users can rebuild the operating system of a workspace to its original state. Default `false`.
 * @property restartWorkspace Whether WorkSpaces directory users can restart their workspace. Default `true`.
 * @property switchRunningMode Whether WorkSpaces directory users can switch the running mode of their workspace. Default `false`.
 */
public data class DirectorySelfServicePermissionsArgs(
    public val changeComputeType: Output<Boolean>? = null,
    public val increaseVolumeSize: Output<Boolean>? = null,
    public val rebuildWorkspace: Output<Boolean>? = null,
    public val restartWorkspace: Output<Boolean>? = null,
    public val switchRunningMode: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.workspaces.inputs.DirectorySelfServicePermissionsArgs> {
    override fun toJava(): com.pulumi.aws.workspaces.inputs.DirectorySelfServicePermissionsArgs =
        com.pulumi.aws.workspaces.inputs.DirectorySelfServicePermissionsArgs.builder()
            .changeComputeType(changeComputeType?.applyValue({ args0 -> args0 }))
            .increaseVolumeSize(increaseVolumeSize?.applyValue({ args0 -> args0 }))
            .rebuildWorkspace(rebuildWorkspace?.applyValue({ args0 -> args0 }))
            .restartWorkspace(restartWorkspace?.applyValue({ args0 -> args0 }))
            .switchRunningMode(switchRunningMode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DirectorySelfServicePermissionsArgs].
 */
@PulumiTagMarker
public class DirectorySelfServicePermissionsArgsBuilder internal constructor() {
    private var changeComputeType: Output<Boolean>? = null

    private var increaseVolumeSize: Output<Boolean>? = null

    private var rebuildWorkspace: Output<Boolean>? = null

    private var restartWorkspace: Output<Boolean>? = null

    private var switchRunningMode: Output<Boolean>? = null

    /**
     * @param value Whether WorkSpaces directory users can change the compute type (bundle) for their workspace. Default `false`.
     */
    @JvmName("xkjwmwjbclfyfnop")
    public suspend fun changeComputeType(`value`: Output<Boolean>) {
        this.changeComputeType = value
    }

    /**
     * @param value Whether WorkSpaces directory users can increase the volume size of the drives on their workspace. Default `false`.
     */
    @JvmName("cwjshrixscaovcio")
    public suspend fun increaseVolumeSize(`value`: Output<Boolean>) {
        this.increaseVolumeSize = value
    }

    /**
     * @param value Whether WorkSpaces directory users can rebuild the operating system of a workspace to its original state. Default `false`.
     */
    @JvmName("surcquiurdqqlrdu")
    public suspend fun rebuildWorkspace(`value`: Output<Boolean>) {
        this.rebuildWorkspace = value
    }

    /**
     * @param value Whether WorkSpaces directory users can restart their workspace. Default `true`.
     */
    @JvmName("rbnrdtlbymerdpnb")
    public suspend fun restartWorkspace(`value`: Output<Boolean>) {
        this.restartWorkspace = value
    }

    /**
     * @param value Whether WorkSpaces directory users can switch the running mode of their workspace. Default `false`.
     */
    @JvmName("tppgevdsechtqdpt")
    public suspend fun switchRunningMode(`value`: Output<Boolean>) {
        this.switchRunningMode = value
    }

    /**
     * @param value Whether WorkSpaces directory users can change the compute type (bundle) for their workspace. Default `false`.
     */
    @JvmName("rbpycdvfxptqdacn")
    public suspend fun changeComputeType(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.changeComputeType = mapped
    }

    /**
     * @param value Whether WorkSpaces directory users can increase the volume size of the drives on their workspace. Default `false`.
     */
    @JvmName("ukjraqrrofvajofr")
    public suspend fun increaseVolumeSize(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.increaseVolumeSize = mapped
    }

    /**
     * @param value Whether WorkSpaces directory users can rebuild the operating system of a workspace to its original state. Default `false`.
     */
    @JvmName("krfjmqlqqsnkjlyx")
    public suspend fun rebuildWorkspace(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rebuildWorkspace = mapped
    }

    /**
     * @param value Whether WorkSpaces directory users can restart their workspace. Default `true`.
     */
    @JvmName("nridfemqaolgoqvj")
    public suspend fun restartWorkspace(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restartWorkspace = mapped
    }

    /**
     * @param value Whether WorkSpaces directory users can switch the running mode of their workspace. Default `false`.
     */
    @JvmName("mvsymhqlwnttquog")
    public suspend fun switchRunningMode(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.switchRunningMode = mapped
    }

    internal fun build(): DirectorySelfServicePermissionsArgs = DirectorySelfServicePermissionsArgs(
        changeComputeType = changeComputeType,
        increaseVolumeSize = increaseVolumeSize,
        rebuildWorkspace = rebuildWorkspace,
        restartWorkspace = restartWorkspace,
        switchRunningMode = switchRunningMode,
    )
}
