@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.workspaces.kotlin.inputs

import com.pulumi.aws.workspaces.inputs.DirectoryWorkspaceCreationPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property customSecurityGroupId The identifier of your custom security group. Should relate to the same VPC, where workspaces reside in.
 * @property defaultOu The default organizational unit (OU) for your WorkSpace directories. Should conform `"OU=<value>,DC=<value>,...,DC=<value>"` pattern.
 * @property enableInternetAccess Indicates whether internet access is enabled for your WorkSpaces.
 * @property enableMaintenanceMode Indicates whether maintenance mode is enabled for your WorkSpaces. For more information, see [WorkSpace Maintenance](https://docs.aws.amazon.com/workspaces/latest/adminguide/workspace-maintenance.html)..
 * @property userEnabledAsLocalAdministrator Indicates whether users are local administrators of their WorkSpaces.
 */
public data class DirectoryWorkspaceCreationPropertiesArgs(
    public val customSecurityGroupId: Output<String>? = null,
    public val defaultOu: Output<String>? = null,
    public val enableInternetAccess: Output<Boolean>? = null,
    public val enableMaintenanceMode: Output<Boolean>? = null,
    public val userEnabledAsLocalAdministrator: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.workspaces.inputs.DirectoryWorkspaceCreationPropertiesArgs> {
    override fun toJava(): com.pulumi.aws.workspaces.inputs.DirectoryWorkspaceCreationPropertiesArgs =
        com.pulumi.aws.workspaces.inputs.DirectoryWorkspaceCreationPropertiesArgs.builder()
            .customSecurityGroupId(customSecurityGroupId?.applyValue({ args0 -> args0 }))
            .defaultOu(defaultOu?.applyValue({ args0 -> args0 }))
            .enableInternetAccess(enableInternetAccess?.applyValue({ args0 -> args0 }))
            .enableMaintenanceMode(enableMaintenanceMode?.applyValue({ args0 -> args0 }))
            .userEnabledAsLocalAdministrator(
                userEnabledAsLocalAdministrator?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [DirectoryWorkspaceCreationPropertiesArgs].
 */
@PulumiTagMarker
public class DirectoryWorkspaceCreationPropertiesArgsBuilder internal constructor() {
    private var customSecurityGroupId: Output<String>? = null

    private var defaultOu: Output<String>? = null

    private var enableInternetAccess: Output<Boolean>? = null

    private var enableMaintenanceMode: Output<Boolean>? = null

    private var userEnabledAsLocalAdministrator: Output<Boolean>? = null

    /**
     * @param value The identifier of your custom security group. Should relate to the same VPC, where workspaces reside in.
     */
    @JvmName("nuykppqqaxdykujs")
    public suspend fun customSecurityGroupId(`value`: Output<String>) {
        this.customSecurityGroupId = value
    }

    /**
     * @param value The default organizational unit (OU) for your WorkSpace directories. Should conform `"OU=<value>,DC=<value>,...,DC=<value>"` pattern.
     */
    @JvmName("jawfxcsxgrgpypoe")
    public suspend fun defaultOu(`value`: Output<String>) {
        this.defaultOu = value
    }

    /**
     * @param value Indicates whether internet access is enabled for your WorkSpaces.
     */
    @JvmName("yqufmbjkuihstjlg")
    public suspend fun enableInternetAccess(`value`: Output<Boolean>) {
        this.enableInternetAccess = value
    }

    /**
     * @param value Indicates whether maintenance mode is enabled for your WorkSpaces. For more information, see [WorkSpace Maintenance](https://docs.aws.amazon.com/workspaces/latest/adminguide/workspace-maintenance.html)..
     */
    @JvmName("jmdytkmfedutxujv")
    public suspend fun enableMaintenanceMode(`value`: Output<Boolean>) {
        this.enableMaintenanceMode = value
    }

    /**
     * @param value Indicates whether users are local administrators of their WorkSpaces.
     */
    @JvmName("tgwtqtbibvttqkyl")
    public suspend fun userEnabledAsLocalAdministrator(`value`: Output<Boolean>) {
        this.userEnabledAsLocalAdministrator = value
    }

    /**
     * @param value The identifier of your custom security group. Should relate to the same VPC, where workspaces reside in.
     */
    @JvmName("scwnidklsaimbosd")
    public suspend fun customSecurityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customSecurityGroupId = mapped
    }

    /**
     * @param value The default organizational unit (OU) for your WorkSpace directories. Should conform `"OU=<value>,DC=<value>,...,DC=<value>"` pattern.
     */
    @JvmName("fwddvpcueywjpqtc")
    public suspend fun defaultOu(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultOu = mapped
    }

    /**
     * @param value Indicates whether internet access is enabled for your WorkSpaces.
     */
    @JvmName("ykpvnvuvltubdset")
    public suspend fun enableInternetAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableInternetAccess = mapped
    }

    /**
     * @param value Indicates whether maintenance mode is enabled for your WorkSpaces. For more information, see [WorkSpace Maintenance](https://docs.aws.amazon.com/workspaces/latest/adminguide/workspace-maintenance.html)..
     */
    @JvmName("ajxtlykmlfigtyfh")
    public suspend fun enableMaintenanceMode(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableMaintenanceMode = mapped
    }

    /**
     * @param value Indicates whether users are local administrators of their WorkSpaces.
     */
    @JvmName("cotiovfaojwadnvw")
    public suspend fun userEnabledAsLocalAdministrator(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userEnabledAsLocalAdministrator = mapped
    }

    internal fun build(): DirectoryWorkspaceCreationPropertiesArgs =
        DirectoryWorkspaceCreationPropertiesArgs(
            customSecurityGroupId = customSecurityGroupId,
            defaultOu = defaultOu,
            enableInternetAccess = enableInternetAccess,
            enableMaintenanceMode = enableMaintenanceMode,
            userEnabledAsLocalAdministrator = userEnabledAsLocalAdministrator,
        )
}
