@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.workspaces.kotlin.inputs

import com.pulumi.aws.workspaces.inputs.GetBundlePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getBundle.
 * @property bundleId ID of the bundle.
 * @property name Name of the bundle. You cannot combine this parameter with `bundle_id`.
 * @property owner Owner of the bundles. You have to leave it blank for own bundles. You cannot combine this parameter with `bundle_id`.
 */
public data class GetBundlePlainArgs(
    public val bundleId: String? = null,
    public val name: String? = null,
    public val owner: String? = null,
) : ConvertibleToJava<com.pulumi.aws.workspaces.inputs.GetBundlePlainArgs> {
    override fun toJava(): com.pulumi.aws.workspaces.inputs.GetBundlePlainArgs =
        com.pulumi.aws.workspaces.inputs.GetBundlePlainArgs.builder()
            .bundleId(bundleId?.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 }))
            .owner(owner?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBundlePlainArgs].
 */
@PulumiTagMarker
public class GetBundlePlainArgsBuilder internal constructor() {
    private var bundleId: String? = null

    private var name: String? = null

    private var owner: String? = null

    /**
     * @param value ID of the bundle.
     */
    @JvmName("kiumhpmplkacctyr")
    public suspend fun bundleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.bundleId = mapped
    }

    /**
     * @param value Name of the bundle. You cannot combine this parameter with `bundle_id`.
     */
    @JvmName("ijbecghofamaekfm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Owner of the bundles. You have to leave it blank for own bundles. You cannot combine this parameter with `bundle_id`.
     */
    @JvmName("ctbgekvdouuppwlr")
    public suspend fun owner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.owner = mapped
    }

    internal fun build(): GetBundlePlainArgs = GetBundlePlainArgs(
        bundleId = bundleId,
        name = name,
        owner = owner,
    )
}
